<?php

namespace idoit\Module\RelocateCi\Controller;

use Exception;
use idoit\Module\RelocateCi\Model\Tree;
use isys_application;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 *
 */
class TreeController
{
    /**
     * Find located devices in the 'source' tree.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function getPath(Request $request): Response
    {
        try {
            $physical = $request->query->get('type') === 'physical';
            $objectId = (int)$request->query->get('objectId');

            $treeModel = Tree::instance(isys_application::instance()->container->get('database'));

            if ($physical) {
                $results = $treeModel->getPhysicalPath($objectId);
            } else {
                $results = $treeModel->getLogicalPath($objectId);
            }

            return new JsonResponse([
                'success' => true,
                'data'    => array_map(fn ($item) => $item['id'], $results),
                'message' => ''
            ]);
        } catch (Exception $e) {
            return new JsonResponse([
                'success' => false,
                'data'    => null,
                'message' => $e->getMessage()
            ]);
        }
    }
}
