<?php

namespace idoit\Module\RelocateCi\Model;

use Exception;
use idoit\Model\Dao\Base;
use isys_application;
use isys_cmdb_dao_category_g_logical_unit;
use isys_cmdb_dao_location;
use isys_component_dao_result;
use isys_exception_database;
use isys_helper_link as HelperLink;

/**
 * Class Ci
 *
 * @package idoit\Module\Examplechecklist\Model
 */
class Ci extends Base
{
    public const OBJECT_TYPES_FOR_LOGICAL_RELOCATION = ['C__OBJTYPE__PERSON', 'C__OBJTYPE__WORKSTATION'];

    /**
     * @var array
     */
    private $objectTitleCache = [];

    /**
     * @param int $objectId
     *
     * @return isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getObjectData(int $objectId): isys_component_dao_result
    {
        $objectId = $this->convert_sql_id($objectId);

        $sql = "SELECT
                isys_obj__id AS id,
                isys_obj__title AS title,
                isys_obj_type__id AS typeId,
                isys_obj_type__const AS typeConst,
                isys_obj_type__title AS typeTitle
            FROM isys_obj
            INNER JOIN isys_obj_type ON isys_obj_type__id = isys_obj__isys_obj_type__id
            WHERE isys_obj__id = {$objectId}
            LIMIT 1";

        return $this->retrieve($sql);
    }

    /**
     * @param int $objectId
     *
     * @return bool
     * @throws \isys_exception_database
     */
    public function usableForPhysicalRelocation(int $objectId): bool
    {
        $objectId = $this->convert_sql_id($objectId);

        $sql = "SELECT isys_obj_type__container AS container, isys_obj_type__const AS const
            FROM isys_obj_type
            INNER JOIN isys_obj ON isys_obj__isys_obj_type__id = isys_obj_type__id
            WHERE isys_obj__id = {$objectId}
            LIMIT 1;";

        $row = $this->retrieve($sql)->get_row();

        return $row['container'] && !in_array($row['const'], self::OBJECT_TYPES_FOR_LOGICAL_RELOCATION, true);
    }

    /**
     * @param int|null $objectId
     *
     * @return string
     * @throws \isys_exception_database
     */
    public function objectTitle(?int $objectId): string
    {
        if (!$objectId) {
            return '';
        }

        if (isset($this->objectTitleCache[$objectId])) {
            return $this->objectTitleCache[$objectId];
        }

        $language = isys_application::instance()->container->get('language');

        $objectData = $this
            ->getObjectData($objectId)
            ->get_row();

        return $this->objectTitleCache[$objectId] = $language->get($objectData['typeTitle']) . ' > ' . $objectData['title'];
    }

    /**
     * Method for getting the correct object type icon path.
     *
     * @param ?int $id
     *
     * @return string
     */
    public static function objectTypeIconPath(?int $id = null): string
    {
        $routeGenerator = isys_application::instance()->container->get('route_generator');

        if ($id) {
            return $routeGenerator->generate('cmdb.object-type.icon', ['objectTypeId' => $id]);
        }

        return $routeGenerator->generate('cmdb.object-type.icon-name', ['filename' => 'document-color-grey.svg']);
    }

    /**
     * Method for retrieving physically- and logically assigned objects.
     *
     * @param int $objectId
     *
     * @return array
     * @throws Exception
     * @throws isys_exception_database
     */
    public function getLocatedObjects(int $objectId): array
    {
        $return = [];
        $language = isys_application::instance()->container->get('language');
        $physicalChildrenResult = isys_cmdb_dao_location::instance($this->m_db)
            ->get_child_locations($objectId, true, false);
        $logicalChildrenResult = isys_cmdb_dao_category_g_logical_unit::instance($this->m_db)
            ->get_data_by_parent($objectId);

        while ($physicalChild = $physicalChildrenResult->get_row()) {
            $return[] = [
                'id'        => (int)$physicalChild['isys_obj__id'],
                'title'     => $physicalChild['isys_obj__title'],
                'typeConst' => $physicalChild['isys_obj_type__const'],
                'typeTitle' => $language->get($physicalChild['isys_obj_type__title']),
                'typeIcon'  => self::objectTypeIconPath((int)$physicalChild['isys_obj_type__id']),
                'located'   => 'physical'
            ];
        }

        while ($logicalChild = $logicalChildrenResult->get_row()) {
            $return[] = [
                'id'        => (int)$logicalChild['isys_obj__id'],
                'title'     => $logicalChild['isys_obj__title'],
                'typeConst' => $logicalChild['isys_obj_type__const'],
                'typeTitle' => $language->get($logicalChild['isys_obj_type__title']),
                'typeIcon'  => self::objectTypeIconPath((int)$logicalChild['isys_obj_type__id']),
                'located'   => 'logical'
            ];
        }

        return $return;
    }

    /**
     * @return array
     * @throws isys_exception_database
     */
    public function getLocationObjectTypes(): array
    {
        $objectTypes = [];
        $normalStatus = $this->convert_sql_int(C__RECORD_STATUS__NORMAL);

        $subQuery = "SELECT isys_obj_type_2_isysgui_catg__isys_obj_type__id
            FROM isys_obj_type_2_isysgui_catg
            INNER JOIN isysgui_catg ON isysgui_catg__id = isys_obj_type_2_isysgui_catg__isysgui_catg__id
            WHERE isysgui_catg__const IN ('C__CATG__ASSIGNED_LOGICAL_UNIT', 'C__CATG__OBJECT')";

        $sql = "SELECT isys_obj_type__id AS id
            FROM isys_obj_type
            WHERE isys_obj_type__status = {$normalStatus}
            AND (isys_obj_type__container = 1 OR isys_obj_type__id IN ({$subQuery}));";

        $result = $this->retrieve($sql);

        while ($row = $result->get_row()) {
            $objectTypes[] = (int)$row['id'];
        }

        return $objectTypes;
    }
}
