<?php

namespace idoit\Module\RelocateCi\Model;

use idoit\Model\Dao\Base;
use isys_cmdb_dao_category_g_location;
use isys_cmdb_dao_category_g_logical_unit;
use isys_component_dao_result;
use isys_exception_database;

/**
 *
 */
class Tree extends Base
{
    /**
     * @param string $searchTerm
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function findObject(string $searchTerm): isys_component_dao_result
    {
        $searchTerm = $this->convert_sql_text('%' . trim($searchTerm) . '%');
        $statusNormal = $this->convert_sql_int(C__RECORD_STATUS__NORMAL);

        $query = "SELECT isys_obj__id AS objectId,
                isys_obj__title AS objectTitle,
                isys_catg_location_list__parentid AS physical,
                isys_catg_logical_unit_list__isys_obj__id__parent AS logical
            FROM isys_obj
            LEFT JOIN isys_catg_location_list ON isys_catg_location_list__isys_obj__id = isys_obj__id
            LEFT JOIN isys_catg_logical_unit_list ON isys_catg_logical_unit_list__isys_obj__id = isys_obj__id
            WHERE isys_obj__title LIKE {$searchTerm}
            AND (isys_catg_location_list__parentid > 0 OR isys_catg_logical_unit_list__isys_obj__id__parent > 0)
            AND isys_catg_location_list__status = {$statusNormal}
            AND isys_obj__status = {$statusNormal};";

        return $this->retrieve($query);
    }

    /**
     * @param int $objectId
     *
     * @return array
     */
    public function getPhysicalPath(int $objectId): array
    {
        $result = [];

        $dao = isys_cmdb_dao_category_g_location::instance($this->m_db);
        $path = $dao->get_location_path($objectId);

        // Prepend the root location.
        $path[] = C__OBJ__ROOT_LOCATION;

        $path = array_reverse($path);

        // Append the current object.
        $path[] = $objectId;

        foreach ($path as $pathObjectId) {
            $result[] = [
                'id'    => (int)$pathObjectId,
                'title' => $dao->get_obj_name_by_id_as_string($pathObjectId)
            ];
        }

        return $result;
    }

    /**
     * @param int $objectId
     *
     * @return array
     */
    public function getLogicalPath(int $objectId): array
    {
        $dao = isys_cmdb_dao_category_g_logical_unit::instance($this->m_db);
        $path = explode(',', $dao->get_node_hierarchy($objectId));

        $path = array_reverse($path);

        $result = $this->getPhysicalPath($path[0]);

        unset($path[0]);

        foreach ($path as $pathObjectId) {
            $result[] = [
                'id'    => (int)$pathObjectId,
                'title' => $dao->get_obj_name_by_id_as_string($pathObjectId)
            ];
        }

        return $result;
    }
}
