<?php

namespace idoit\Module\RelocateCi\Tree;

use idoit\Component\Tree\TreeFilterInterface;
use idoit\Module\RelocateCi\Model\Ci;
use isys_component_database;

class TargetFilter implements TreeFilterInterface
{
    private Ci $model;

    private array $allowedObjectTypes;

    /**
     * @param isys_component_database $database
     *
     * @throws \isys_exception_database
     */
    public function __construct(isys_component_database $database)
    {
        $this->model = Ci::instance($database);
        $this->allowedObjectTypes = $this->model->getLocationObjectTypes();
    }

    /**
     * @param int|null $parentObjectId
     * @param string   $mode
     * @param int      $objectId
     *
     * @return bool
     * @throws \isys_exception_database
     */
    public function shouldSkip(?int $parentObjectId, string $mode, int $objectId): bool
    {
        $query = "SELECT isys_obj__isys_obj_type__id AS typeId
            FROM isys_obj
            WHERE isys_obj__id = {$objectId}
            LIMIT 1";

        $objectTypeId = (int)$this->model->retrieve($query)
            ->get_row_value('typeId');

        return !in_array($objectTypeId, $this->allowedObjectTypes, true);
    }
}
