<div id="module-relocate-ci">
    <p class="p5">[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__RELOCATE_GUI_DESCRIPTION"}]</p>

    <div id="module-relocate-ci-selected-object" class="vat p5">
        <!-- To be filled by JS -->
    </div>

    <table id="module-relocate-ci-tree-container" class="m10">
        <tr>
            <td class="vat">
                <div class="tree-container border mr10">
                    <div class="p5 bg-neutral-200 border-bottom">
                        [{isys type="f_suggestion" name="module-relocate-ci-source-search"}]
                    </div>
                    <div id="relocate_ci_source_tree" class="dtree m10">
                        <!-- "Source" tree - display all CIs -->
                    </div>
                </div>
            </td>
            <td>
                <img src="[{$dir_images}]rsaquo.png" class="mt20 ml10 mr10" />
            </td>
            <td class="vat">
                <div class="tree-container border">
                    <div class="p5 bg-neutral-200 border-bottom">
                        [{isys type="f_suggestion" name="module-relocate-ci-target-search"}]
                    </div>
                    <div id="relocate_ci_destination_tree" class="dtree m10">
                        <!-- "Target" tree - only container objects here -->
                    </div>
                </div>
            </td>
        </tr>
    </table>
</div>

<script type="text/javascript">
    (function () {
        'use strict';

        Position.includeScrollOffsets = true;

        const $sourceSuggestion = $('module-relocate-ci-source-search');
        const $sourceTree = $('relocate_ci_source_tree');

        const $targetSuggestion = $('module-relocate-ci-target-search');
        const $targetTree = $('relocate_ci_destination_tree');

        idoit.Require
            .addModule('relocate-ci.tree', '[{isys_module_relocate_ci::getWwwPath()}]/assets/js/relocate-ci-tree.js')
            .requireQueue(['treeBase', 'relocate-ci.tree'], function () {
                const sourceTree = new window.RelocateCiTree($sourceTree, {
                    onSelect: () => $sourceTree.fire('tree:selection-change')
                });
                const targetTree = new window.RelocateCiTree($targetTree, {
                    multiselect: false,
                    isSource: false,
                    onSelect: () => $sourceTree.fire('tree:selection-change'),
                    onDrop: (sourceNodeId, targetNodeId) => {
                        sourceTree.selectNode(sourceNodeId).process();
                        targetTree.selectNode(targetNodeId).process();

                        $navbarRelocateButton.fire('relocate:trigger');
                    }
                });

                const $navbarRelocateButton = $('navbar_item_relocate')
                const $selectedObjectInfo = $('module-relocate-ci-selected-object');
                const updateSelection = () => {
                    const sourceObjects = [];
                    const selectedSources = sourceTree.getSelectedNodes();
                    const selectedTarget = targetTree.getSelectedNodes();

                    if (selectedSources.length === 0) {
                        $selectedObjectInfo.update('');
                        return;
                    }

                    for (let i in selectedSources) {
                        if (!selectedSources.hasOwnProperty(i)) {
                            continue;
                        }

                        sourceObjects.push(
                            new Element('strong').update(selectedSources[i].nodeTitle).outerHTML + ' (#' + selectedSources[i].nodeId + ')'
                        );
                    }

                    $selectedObjectInfo
                        .update(new Element('strong').update('[{isys type="lang" ident="LC__POPUP__BROWSER__SELECTED_OBJECTS"}]'))
                        .insert(new Element('p', {className: 'mt5'}).update('[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__RELOCATE_GUI_SELECTIONS" p_bHtmlEncode=false}]'));

                    if (sourceObjects.length === 1) {
                        $selectedObjectInfo
                            .update(new Element('strong').update('[{isys type="lang" ident="LC__POPUP__BROWSER__SELECTED_OBJECT"}]'))
                            .insert(new Element('p', {className: 'mt5'}).update('[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__RELOCATE_GUI_SELECTION" p_bHtmlEncode=false}]'));
                    }

                    $selectedObjectInfo.down('.source').update(sourceObjects.join(', '));
                    $selectedObjectInfo.down('.destination').update(selectedTarget.length
                        ? new Element('strong').update(selectedTarget[0].nodeTitle).outerHTML + ' (#' + selectedTarget[0].nodeId + ')'
                        : '[{isys_tenantsettings::get('gui.empty_value', '-')}]');
                };

                $sourceTree.on('tree:set-open-nodes', (ev) => {
                    const openNodes = ev.memo.openNodes || [];
                    sourceTree.setOpenNodes(openNodes).selectNode(openNodes.last()).process();
                });
                $sourceTree.on('tree:process', () => sourceTree.process());
                $sourceTree.on('tree:selection-change', () => updateSelection());
                $sourceTree.fire('tree:process');

                $targetTree.on('tree:set-open-nodes', (ev) => {
                    const openNodes = ev.memo.openNodes || [];
                    targetTree.setOpenNodes(openNodes).selectNode(openNodes.last()).process();
                });
                $targetTree.on('tree:process', () => targetTree.process());
                $targetTree.on('tree:selection-change', () => updateSelection());
                $targetTree.fire('tree:process');

                $sourceSuggestion.on('suggestion:afterUpdateElement', function (ev) {
                    const [type, objectId] = extractTypeAndObjectId(ev.memo.selectedChoice);

                    loadPath(type, objectId, (selection) => {
                        $sourceTree.fire('tree:set-open-nodes', { openNodes: selection });
                    })
                });

                $targetSuggestion.on('suggestion:afterUpdateElement', function (ev) {
                    const [type, objectId] = extractTypeAndObjectId(ev.memo.selectedChoice);

                    loadPath(type, objectId, (selection) => {
                        $targetTree.fire('tree:set-open-nodes', { openNodes: selection });
                    })
                });

                const extractTypeAndObjectId = function ($li) {
                    if (!$li || !$li.readAttribute('data-key')) {
                        return;
                    }

                    return $li.readAttribute('data-key').split(':');
                }

                const loadPath = function (type, objectId, callback) {
                    new Ajax.Request('[{$ajaxGetPathUrl}]', {
                        method: 'GET',
                        parameters: {
                            'type': type,
                            'objectId': objectId
                        },
                        onComplete: function (xhr) {
                            if (!is_json_response(xhr, true)) {
                                return;
                            }

                            const json = xhr.responseJSON;

                            if (!json.success) {
                                idoit.Notify.error(json.message);
                                return;
                            }

                            callback(json.data);
                        }
                    });
                }

                if ($navbarRelocateButton) {
                    $navbarRelocateButton.on('relocate:trigger', function () {
                        const sourceSelection = sourceTree.getSelectedNodes();
                        const targetSelection = targetTree.getSelectedNodes();

                        if (!targetSelection.length || !sourceSelection.length) {
                            idoit.Notify.info('[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__YOU_NEED_TO_SELECT_AT_LEAST_TWO_OBJECTS"}]');
                            return;
                        }

                        new Ajax.Request('[{$ajaxPreRelocateCheckUrl}]', {
                            method: 'POST',
                            parameters: {
                                sources: JSON.stringify(sourceSelection.map((source) => source.nodeId)),
                                targets: JSON.stringify(targetSelection.map((target) => target.nodeId))
                            },
                            onComplete: function (xhr) {
                                if (!is_json_response(xhr, true)) {
                                    return;
                                }

                                const json = xhr.responseJSON;

                                if (!json.success) {
                                    idoit.Notify.error(json.message, {sticky:true});
                                    return;
                                }

                                get_popup('relocate_ci_selection', '', 900, 500, {
                                    relocationObjects: JSON.stringify(json.data.sourceData),
                                    destinationObject: json.data.destinationObjectId
                                });
                            }
                        });

                        // Reprepare the draggables - they seem to get lost after something was dropped.
                        sourceTree.prepareDraggables();
                        targetTree.prepareDraggables();
                    });
                }

                idoit.callbackManager.registerCallback('module-relocate-ci-update-tree', function (objects, destinationObjectId) {
                    sourceTree.reset();
                    targetTree.reset();
                    updateSelection();
                });

                $sourceSuggestion.focus();
            });
    })();
</script>

<style>
    #module-relocate-ci {
        box-sizing: border-box;
        position: relative;
    }

    #relocate_ci_source_tree,
    #relocate_ci_destination_tree {
        min-height: 250px;
        max-height: 400px;
        overflow-x: hidden;
        overflow-y: auto;
    }

    #drag-ghost {
        position: absolute;
        z-index: 1300;
    }

    #module-relocate-ci .tree-container {
        width: 450px;
        background: #ffffff;
    }

    #module-relocate-ci-tree-container {
        position: relative;
    }

    #module-relocate-ci-tree-container .node-div.active {
        background: #d4ffde;
    }

    #module-relocate-ci-tree-container .node-div a.fr {
        position: relative;
        z-index: 700;
        top: 2px;
    }

    #module-relocate-ci .tree-container .drop {
        background: #d4ffde;
        border-radius: 5px;
    }
</style>
