<?php
/**
 * i-doit
 *
 * "Swap CI" Module initializer
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

if (isys_module_manager::instance()->is_active('swapci')) {
    require_once __DIR__ . '/isys_module_swapci_autoload.class.php';

    spl_autoload_register('isys_module_swapci_autoload::init');

    // Handle add-on specific report views.
    isys_register::factory('additional-report-views')
        ->set(__DIR__ . '/reportview/isys_swapci_reportview_show_objects.class.php');

    // Connect a new method to the "beforeRender" signal from the navbar.
    isys_application::instance()->container->get('signals')
        ->connect('system.navbar.beforeAssignment', ['isys_module_swapci', 'add_swap_button']);
}
