<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.1.1
 */
class isys_module_swapci_autoload extends isys_module_manager_autoload
{
    /**
     * Legacy autoloader.
     *
     * @param  string $className
     *
     * @return boolean
     */
    public static function init($className)
    {
        $base = '/src/classes/modules/swapci/';
        $classMap = [
            'isys_ajax_handler_swapci' => 'handler/ajax/isys_ajax_handler_swapci.class.php',
            'isys_auth_swapci' => 'auth/isys_auth_swapci.class.php',
            'isys_swapci_dao' => 'dao/isys_swapci_dao.class.php',
            'isys_swapci_reportview_show_objects' => 'reportview/isys_swapci_reportview_show_objects.class.php',
            'isys_swapci_swap' => 'swap/isys_swapci_swap.class.php',
        ];

        if (isset($classMap[$className]) && parent::include_file($base . $classMap[$className])) {
            isys_caching::factory('autoload')->set($className, $base . $classMap[$className]);

            return true;
        }

        return false;
    }
}
