<?php

/**
 * i-doit
 *
 * Report View for the "Swap CI" module.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Leonard Fischer <lfischer@i-doit.org>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.1.1
 */
class isys_swapci_reportview_show_objects extends isys_report_view
{
    /**
     * Method for ajax-requests.
     *
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public function ajax_request()
    {
        echo '{"success":true}';
        die;
    }

    /**
     * Method for retrieving the language constant of the report-description.
     *
     * @return  string
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public static function description()
    {
        return 'LC__MODULE__SWAPCI__REPORT_DESCRIPTION';
    }

    /**
     * Initialize method.
     *
     * @return  boolean
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public function init()
    {
        return true;
    }

    /**
     * Determines, if a report view is brought in by an external source (module?).
     *
     * @return  boolean
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function external()
    {
        return true;
    }

    /**
     * Method for retrieving the language constant of the report-name.
     *
     * @return  string
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public static function name()
    {
        return 'LC__MODULE__SWAPCI__REPORT';
    }

    /**
     * Start-method - Implement the logic for displaying your data here.
     *
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public function start()
    {
        /**
         * @var  isys_ajax_handler_quick_info $l_quick_info
         */
        $l_dao = isys_swapci_dao::instance(isys_application::instance()->container->get('database'));
        $l_cmdb_dao = isys_cmdb_dao::instance(isys_application::instance()->container->get('database'));
        $l_quick_info = isys_factory::get_instance('isys_ajax_handler_quick_info');

        $l_objects = [];
        $l_ajax_url = array_merge($_GET, ['ajax' => 1]);

        $l_res = $l_dao->load_from_archive();

        while ($l_row = $l_res->get_row()) {
            try {
                $l_log = isys_format_json::decode($l_row['isys_swapci_archive__results']);
            } catch (Exception $e) {
                isys_notify::error($e->getMessage(), ['sticky' => true]);
                $l_log = [];
            }

            $l_object_type = isys_tenantsettings::get('gui.empty_value', '-');

            $l_old_object = '#' . $l_row['isys_swapci_archive__old_obj'] . ' (' . _L('LC__MODULE__SWAPCI__REPORT_OBJECT_NO_LONGER_EXISTS') . ')';
            $l_new_object = '#' . $l_row['isys_swapci_archive__new_obj'] . ' (' . _L('LC__MODULE__SWAPCI__REPORT_OBJECT_NO_LONGER_EXISTS') . ')';

            if ($l_cmdb_dao->obj_exists($l_row['isys_swapci_archive__old_obj'])) {
                $l_object_type = _L($l_cmdb_dao->get_obj_type_name_by_obj_id($l_row['isys_swapci_archive__old_obj']));
                $l_old_object = $l_quick_info->get_quick_info($l_row['isys_swapci_archive__old_obj'],
                    $l_cmdb_dao->get_obj_name_by_id_as_string($l_row['isys_swapci_archive__old_obj']), C__LINK__OBJECT);
            }

            if ($l_cmdb_dao->obj_exists($l_row['isys_swapci_archive__new_obj'])) {
                $l_new_object = $l_quick_info->get_quick_info($l_row['isys_swapci_archive__new_obj'],
                    $l_cmdb_dao->get_obj_name_by_id_as_string($l_row['isys_swapci_archive__new_obj']), C__LINK__OBJECT);
            }

            $l_objects[] = [
                'person'   => $l_cmdb_dao->get_object($l_row['isys_swapci_archive__isys_obj__id'], true)
                    ->get_row(),
                'datetime' => date('d.m.Y H:i:s', strtotime($l_row['isys_swapci_archive__datetime'])),
                'obj_type' => $l_object_type,
                'old_obj'  => $l_old_object,
                'new_obj'  => $l_new_object,
                'results'  => $l_log
            ];
        }

        // Assign the ajax URL to the template.
        isys_application::instance()->container->get('template')
            ->assign('log_debug_level', isys_log::C__DEBUG)
            ->assign('objects', $l_objects)
            ->assign('module_www_dir', isys_module_swapci::getWwwPath() . 'templates/')
            ->assign('ajax_url', isys_helper_link::create_url($l_ajax_url));
    }

    /**
     * Method for retrieving the template-name of this report.
     *
     * @return  string
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public function template()
    {
        return __DIR__ . '/isys_swapci_reportview_show_objects.tpl';
    }

    /**
     * Method for declaring the type of this report.
     *
     * @return  integer
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public static function type()
    {
        return self::c_php_view;
    }

    /**
     * Method for declaring the view-type.
     *
     * @return  string
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public static function viewtype()
    {
        return 'LC__CMDB__CATG__OBJECT';
    }
}
