<link rel="stylesheet" type="text/css" media="screen" href="[{$module_www_dir}]style.css" />
<script type="text/javascript" src="[{$module_www_dir}]list-selector.js"></script>

<div id="module-swapci">
	<h3 class="p5 gradient border-bottom text-shadow">[{isys type="lang" ident="LC__MODULE__SWAPCI__GUI_TITLE"}]</h3>

	<table class="contentTable">
		<tr>
			<td class="key">
				[{isys type="f_label" name="C__MODULE__SWAPCI__OBJECT" ident="LC__MODULE__SWAPCI__GUI_OBJECT_TO_SWAP"}]
			</td>
			<td class="value">
				<div id="old_object" style="position:relative;">
					[{isys name="C__MODULE__SWAPCI__OBJECT" type="f_popup" p_strPopupType="browser_object_ng" callback_accept="window.obj_browser_callback();"}]
				</div>
			</td>
		</tr>
		[{if isys_glob_is_edit_mode() && $from_cmdb_module}]
		<tr>
			<td></td>
			<td class="value">
				<button type="button" id="object_changer" class="ml20 btn disabled" disabled="disabled">
					<img src="[{$dir_images}]icons/silk/arrow_switch.png" title="[{isys type="lang" ident="LC__MODULE__SWAPCI__GUI_CHANGE_OBJECTS"}]" class="mr5" /><span>[{isys type="lang" ident="LC__MODULE__SWAPCI__GUI_CHANGE_OBJECTS"}]</span>
				</button>
			</td>
		</tr>
		[{/if}]
		<tr>
			<td class="key" style="vertical-align: top; padding-top: 5px;">
				[{isys type="f_label" name="C__MODULE__SWAPCI__STORED_OBJECT" ident="LC__MODULE__SWAPCI__GUI_STORED_OBJECT"}]
			</td>
			<td class="value">
				<div id="new_object" style="position:relative;">
					<div id="stored-obj-hider" style="position:absolute; width:100%; height:100%; background:#fff; opacity:0.5;"></div>
					<div id="stored-obj">[{isys name="C__MODULE__SWAPCI__STORED_OBJECT" type="f_popup" p_strPopupType="browser_object_ng" callback_accept="window.obj_browser_callback2();"}]</div>
					<div id="obj-type-missmatch-error" class="box-red ml20 mt5 p5"></div>
				</div>
			</td>
		</tr>
		<tr>
			<td class="key" style="vertical-align: top; padding-top: 5px;">
				[{isys type="f_label" name="C__MODULE__SWAPCI__CATEGORIES" ident="LC__MODULE__SWAPCI__GUI_CATEGORIES_TO_SWAP" description="LC__MODULE__SWAPCI__GUI_CATEGORIES_TO_SWAP_DESCRIPTION"}]
			</td>
			<td class="value">
				[{isys type="f_text" name="categories" p_bInvisible=true p_bInfoIconSpacer=0}]
				<div id="cat-selector" class="border"></div>
			</td>
		</tr>
		<tr>
			<td class="key">[{isys type="f_label" name="C__MODULE__SWAPCI__CONFIG_CONSIDER_STATUS" ident="LC__MODULE__SWAPCI__CONFIG_CONSIDER_STATUS"}]</td>
			<td class="value">[{isys type="f_dialog" name="C__MODULE__SWAPCI__CONFIG_CONSIDER_STATUS" p_strClass="input-mini" p_bDbFieldNN=true}]</td>
		</tr>
		<tr>
			<td class="key">[{isys type="f_label" name="C__MODULE__SWAPCI__CONFIG_ARCHIVE_SWAPPED_OBJ" ident="LC__MODULE__SWAPCI__CONFIG_ARCHIVE_SWAPPED_OBJ"}]</td>
			<td class="value">[{isys type="f_dialog" name="C__MODULE__SWAPCI__CONFIG_ARCHIVE_SWAPPED_OBJ" p_strClass="input-mini" p_bDbFieldNN=true}]</td>
		</tr>
		<tr>
			<td class="key">[{isys type="f_label" name="C__MODULE__SWAPCI__CONFIG_SWAP_SYSID" ident="LC__MODULE__SWAPCI__CONFIG_SWAP_SYSID"}]</td>
			<td class="value">[{isys type="f_dialog" name="C__MODULE__SWAPCI__CONFIG_SWAP_SYSID" p_strClass="input-mini" p_bDbFieldNN=true}]</td>
		</tr>
		<tr>
			<td colspan="2">
				<hr class="mt5 mb5" />
			</td>
		</tr>
		<tr>
			<td></td>
			<td>
				<button id="swap-button" class="btn ml20" type="button">
					<span>[{isys type="lang" ident="LC__MODULE__SWAPCI__GUI_START_SWAPPING"}]</span>
				</button>
			</td>
		</tr>
	</table>

	<h2 id="swap-result-userfriendly" class="p5 m5 mt10 hide"></h2>

	<div id="swap-result" class="m5 hide">
		<button id="swap-result-show-debug" type="button" class="fr btn">
			<img src="[{$dir_images}]icons/silk/bug.png" class="mr5" /><span>[{isys type="lang" ident="LC__MODULE__SWAPCI__GUI_DEBUG_MESSAGES"}]</span>
		</button>
		<div id="swap-result-log"></div>
	</div>
</div>

<script type="text/javascript">
var categories = JSON.parse('[{$categories}]'),
	swap_obj = 0,
	stored_obj = 0,
	obj_type = 0,
	log_icons = JSON.parse('[{$log_icons}]'),
	$swapButton = $('swap-button');

$('obj-type-missmatch-error', 'cat-selector').invoke('hide');

$swapButton.on('click', function () {
	if (swap_obj > 0 && stored_obj > 0 && $$('#cat-selector input:checked').length > 0) {
		$swapButton
			.disable()
			.update(new Element('img', {className:'vam mr5', src:'[{$dir_images}]ajax-loading.gif'}))
			.insert(new Element('span', {className:'vam'}).update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]'));

		new Ajax.Request('[{$ajax_url}]&func=swap',
			{
				parameters: {
					old_obj:swap_obj,
					new_obj:stored_obj,
					obj_type:obj_type,
					categories:$F('categories'),
					consider_status:$F('C__MODULE__SWAPCI__CONFIG_CONSIDER_STATUS'),
					archive_swapped_obj:$F('C__MODULE__SWAPCI__CONFIG_ARCHIVE_SWAPPED_OBJ'),
					swap_sysid:$F('C__MODULE__SWAPCI__CONFIG_SWAP_SYSID')
				},
				method: 'post',
				onSuccess: function (response) {
					var json = response.responseJSON,
						css_class = '',
						output = [],
						log,
						i;

					// Restore the "Swap" button.
					$swapButton
							.enable()
							.update(new Element('span').update('[{isys type="lang" ident="LC__MODULE__SWAPCI__GUI_START_SWAPPING"}]'));

					if (json.success) {
						for (i in json.data.log) {
							if (json.data.log.hasOwnProperty(i)) {
								log = json.data.log[i];
								css_class = '';

								if (log.level == '[{$log_debug_level}]') {
									css_class = ' class="debug hide"';
								}

								output.push('<div' + css_class + '><img class="vam" src="' + log_icons[log.level] + '" /> <span class="vam">' + log.message + '</span></div>');
							}
						}

						$('swap-result-userfriendly')
							.addClassName('box-green')
							.update('[{isys type="lang" ident="LC__MODULE__SWAPCI__GUI_FINISHED"}]')
							.removeClassName('hide');

						$('swap-result').removeClassName('hide').down('#swap-result-log').update(output.join(''));
					} else {
						$('swap-result-userfriendly')
							.addClassName('box-red')
							.update('[{isys type="lang" ident="LC__MODULE__SWAPCI__GUI_FINISHED_WITH_ERROR"}]')
							.removeClassName('hide');

						$('swap-result').removeClassName('hide').down('#swap-result-log').update(new Element('img', {className:'vam', src:'[{$dir_images}]icons/error_icon.png'})).insert(json.message);
					}
				}.bind(this)
			});
	}
});

$('swap-result-show-debug').on('click', function () {
	$$('#swap-result-log div.debug').invoke('toggleClassName', 'hide')
});

// Callback method for setting the second object-browser (this will get the "object type" filter).
window.obj_browser_callback = function () {
	var obj = $F('C__MODULE__SWAPCI__OBJECT__HIDDEN');

	[{if isys_glob_is_edit_mode() && $from_cmdb_module}]
	$('object_changer').disable().addClassName('disabled');
	[{/if}]

	$('stored-obj').removeClassName('hide');

	if (! obj.blank() && obj > 0) {
		new Ajax.Request('[{$ajax_url}]&func=get_second_obj_browser',
			{
				parameters: {
					swap_object:obj
				},
				method: 'post',
				onSuccess: function (response) {
					var json = response.responseJSON;

					$('stored-obj-hider').addClassName('hide');
					$('stored-obj').update(json.data);
				}.bind(this)
			});
	}
};

// Callback method for the second object browser. This will load and check the "storing" object.
window.obj_browser_callback2 = function () {
	var obj = $F('C__MODULE__SWAPCI__OBJECT__HIDDEN'),
		dest_obj = $F('C__MODULE__SWAPCI__STORED_OBJECT__HIDDEN'),
		missmatch_container = $('obj-type-missmatch-error').hide();

	swap_obj = 0;
	stored_obj = 0;

	[{if isys_glob_is_edit_mode() && $from_cmdb_module}]
	$('object_changer').disable().addClassName('disabled');
	[{/if}]

	if (! obj.blank() && ! dest_obj.blank()) {
		new Ajax.Request('[{$ajax_url}]&func=match_object_types',
			{
				parameters: {
					obj_a:obj,
					obj_b:dest_obj
				},
				method: 'post',
				onSuccess: function (response) {
					var json = response.responseJSON;

					if (! json.success) {
						missmatch_container.show().update(json.message);
					} else {
						obj_type = json.data;
						swap_obj = obj;
						stored_obj = dest_obj;

						// Start the "ListSelector".
						[{if isys_glob_is_edit_mode() && $from_cmdb_module}]
						$('object_changer').enable().removeClassName('disabled');
						[{/if}]
						window.initialize_list_selector();
					}
				}.bind(this)
			});
	}
};

window.initialize_list_selector = function () {
	new Ajax.Request('[{$ajax_url}]&func=retrieve_selected_categories',
		{
			parameters: {
				obj_type:obj_type,
				with_data_from:swap_obj
			},
			method: 'post',
			onSuccess: function (response) {
				var json = response.responseJSON,
					cat_receiver_id = 'categories',
					cat_receiver = $(cat_receiver_id),
					selected_categories = [],
					available_categories = [],
					cnt = categories.length,
					cat,
					i;

				for (i=0; i<cnt; i++) {
					if (json.data.hasOwnProperty(categories[i]['const'])) {
						cat = categories[i];

						if (json.data[categories[i]['const']] === true) {
							cat.selected = true;
							selected_categories.push(categories[i]['const']);
						} else {
							cat.selected = false;
						}

						available_categories.push(cat);
					}
				}

				cat_receiver.setValue(Object.toJSON(selected_categories));

				new ListSelector('cat-selector', {
					title:'[{isys type="lang" ident="LC_UNIVERSAL__CATEGORIES"}]',
					receiver:cat_receiver_id,
					items:available_categories
				});
			}.bind(this)
		});
};

window.change_object_selection = function () {
	var old_obj = $('old_object').absolutize(),
		new_obj = $('new_object').absolutize(),
		old_top = old_obj.getStyle('top'),
		new_top = new_obj.getStyle('top');

	// A nice slide-animation
	new Effect.Morph(old_obj, {style:{top:new_top}, duration:0.70});
	new Effect.Morph(new_obj, {style:{top:old_top}, duration:0.75, afterFinish:function() {
		var tmp;

		// Swap the values (view and hidden).
		tmp = $F('C__MODULE__SWAPCI__OBJECT__VIEW');
		$('C__MODULE__SWAPCI__OBJECT__VIEW').setValue($F('C__MODULE__SWAPCI__STORED_OBJECT__VIEW'));
		$('C__MODULE__SWAPCI__STORED_OBJECT__VIEW').setValue(tmp);

		tmp = $F('C__MODULE__SWAPCI__OBJECT__HIDDEN');
		$('C__MODULE__SWAPCI__OBJECT__HIDDEN').setValue($F('C__MODULE__SWAPCI__STORED_OBJECT__HIDDEN'));
		$('C__MODULE__SWAPCI__STORED_OBJECT__HIDDEN').setValue(tmp);

		// And change the form-fields back.
		old_obj.writeAttribute('style', 'position:relative');
		new_obj.writeAttribute('style', 'position:relative');

		// Maybe it's necessary to reload the categorie-list
		window.obj_browser_callback2();
	}.bind(this)});
};

[{if isys_glob_is_edit_mode() && $from_cmdb_module}]
$('object_changer').on('click', window.change_object_selection);
[{/if}]

[{if $new_is_filled}]
// This will only be executed, when we selected two objects via object-list.
window.obj_browser_callback2();
$('stored-obj-hider').addClassName('hide');
[{elseif $old_is_filled}]
window.obj_browser_callback();
[{/if}]
</script>
