<link rel="stylesheet" type="text/css" media="screen" href="[{$module_www_dir}]style.css" />
<script type="text/javascript" src="[{$module_www_dir}]list-selector.js"></script>

<div id="module-swapci">
	<h3 class="p5 gradient border-bottom text-shadow">[{isys type="lang" ident="LC__MODULE__SWAPCI__GUI_TITLE"}]</h3>

	<table class="contentTable">
		<tr>
			<td class="key">
				[{isys type="f_label" name="object_type_selection" ident="LC__MODULE__SWAPCI__GUI_BY_WORKPLACE__OBJ_TYPE_SELECTION"}]
			</td>
			<td class="value">
				[{isys type="f_dialog" name="object_type_selection" p_strClass="normal"}]
			</td>
		</tr>
	</table>

	<h3 id="location_tree_title" class="p5 gradient border-top border-bottom text-shadow mt10">
		<button type="button" class="btn btn-small fr" style="margin-top: -3px;" id="module-swapci-tree-toggle">
			<span>[{isys type="lang" ident="LC__MODULE__SWAPCI__GUI_BY_WORKPLACE__TOGGLE_TREE"}]</span>
		</button>
		[{isys type="lang" ident="LC__MODULE__SWAPCI__GUI_BY_WORKPLACE__TREE_TITLE" p_bHtmlEncode=false}]
	</h3>
	<div class="p5">
		<button type="button" class="swap-button btn mb10">
			<span>[{isys type="lang" ident="LC__MODULE__SWAPCI__GUI_BY_WORKPLACE__SWAP_BUTTON"}]</span>
		</button>

		<div id="location_tree"></div>

		<button type="button" class="swap-button btn mt10">
			<span>[{isys type="lang" ident="LC__MODULE__SWAPCI__GUI_BY_WORKPLACE__SWAP_BUTTON"}]</span>
		</button>
	</div>
</div>

<script type="text/javascript">
	var location_tree;

	$('object_type_selection').on('change', function () {
		$('location_tree_title').down('span').update($('object_type_selection').select('option:selected')[0].innerHTML);

		new Ajax.Request('[{$ajax_url}]&func=get_workplaces_by_obj_type',
			{
				parameters: {
					obj_type:$F('object_type_selection')
				},
				method: 'post',
				onSuccess: function (response) {
					var json = response.responseJSON,
						workplace,
						checkbox,
						title,
						object,
						i2,
						i;

					location_tree = new dTree('location_tree', '[{$dir_images}]dtree/');

					location_tree.add(1, -1, '[{isys type="lang" ident="LC__CMDB__OBJTYPE__WORKPLACES"}]', '', '', '', '', '', 0, '', 0, '');

					for (i in json.data) {
						if (json.data.hasOwnProperty(i)) {
							workplace = json.data[i];

							location_tree.add(
								workplace.id,
								1,
								workplace.name + ' (' + workplace.type_name + ')',
								'',
								'',
								'',
								workplace.icon,
								workplace.icon,
								0,
								'',
								0,
								'');

							for (i2 in workplace.children) {
								if (workplace.children.hasOwnProperty(i2)) {
									object = workplace.children[i2];
									checkbox = new Element('label')
										.update(new Element('input', {type:'checkbox', value:object.id, className:'ml5 vam'}))
										.insert(new Element('span', {className:'ml5 vam'}).update(object.name + ' (' + object.type_name + ')')).outerHTML;
									title = new Element('span', {style:'margin-left:23px;'}).update(object.name + ' (' + object.type_name + ')').outerHTML;

									location_tree.add(
										object.id,
										workplace.id,
										(object.allowed_to_swap ? checkbox : title),
										'',
										'',
										'',
										object.icon,
										object.icon,
										1,
										'',
										0,
										'');
								}
							}
						}
					}

					$('location_tree').update(location_tree);
				}
			});
	});

	$('location_tree').on('click', 'input[type="checkbox"]', function () {
		var checkboxes = $$('#location_tree input[type="checkbox"]:checked');

		if (checkboxes.length == 2) {
			$$('#location_tree input[type="checkbox"]:not(:checked)').invoke('disable');
		} else {
			$$('#location_tree input[type="checkbox"]').invoke('enable');
		}
	});

	$$('.swap-button').invoke('on', 'click', function () {
		window.location.href = '[{$swap_gui_url}]&[{$smarty.const.C__CMDB__GET__OBJECT}]=' + $$('#location_tree input[type="checkbox"]:checked').invoke('getValue').join();
	});

	$('module-swapci-tree-toggle').on('click', function () {
		if (location_tree) {
			var close = this.hasClassName('active');

			if (! close) {
				this.addClassName('active');
			} else {
				this.removeClassName('active');
			}

			location_tree.oAll(! close);
		}
	});
</script>