<?php

/**
 * i-doit
 *
 * Swap CI module DAO.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.1.1
 */
class isys_swapci_dao extends isys_module_dao
{
    /**
     * This variable will hold the complete "Swap CI" configuration.
     *
     * @var  array
     */
    protected static $m_config;

    /**
     * get_data always retrieves the data of the main table of this module.
     */
    public function get_data()
    {
    }

    /**
     * Method for saving multiple configuration options.
     *
     * @param   array $p_options
     *
     * @return  isys_swapci_dao
     * @throws  isys_exception_dao
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function save_config(array $p_options = [])
    {
        if (count($p_options) > 0) {
            foreach ($p_options as $l_key => $l_data) {
                $l_type = $l_data['type'];
                $l_value = $l_data['value'];

                $l_sql = 'UPDATE isys_swapci_config
					SET isys_swapci_config__value = ' . $this->convert_sql_text(trim($l_value)) . ',
					isys_swapci_config__type = ' . $this->convert_sql_text($l_type) . '
					WHERE isys_swapci_config__key = ' . $this->convert_sql_text($l_key) . ';';

                if (!($this->update($l_sql) && $this->apply_update())) {
                    throw new isys_exception_dao($this->get_database_component()->get_last_error_as_string());
                }
            }
        }

        return $this;
    }

    /**
     * This method will add new object-type configurations and overwrite them, in case they already exist.
     *
     * @param   array $p_obj_types
     *
     * @return  isys_swapci_dao
     * @throws  isys_exception_database
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function save_obj_type_config(array $p_obj_types = [])
    {
        foreach ($p_obj_types as $l_key => $l_value) {
            // Decide if "INSERT" or "UPDATE".
            if ($this->config_key_exists($l_key)) {
                // Update.
                $l_sql = 'UPDATE isys_swapci_config
					SET isys_swapci_config__value = ' . $this->convert_sql_text($l_value) . '
					WHERE isys_swapci_config__key = ' . $this->convert_sql_text($l_key) . ';';
            } else {
                // Insert.
                $l_sql = 'INSERT INTO isys_swapci_config (isys_swapci_config__type, isys_swapci_config__key, isys_swapci_config__value)
					VALUES (' . $this->convert_sql_text(C__TYPE__JSON) . ', ' . $this->convert_sql_text($l_key) . ', ' . $this->convert_sql_text($l_value) . ');';
            }

            if (!($this->update($l_sql) && $this->apply_update())) {
                throw new isys_exception_database($this->get_database_component()->get_last_error_as_string());
            }
        }

        return $this;
    }

    /**
     * Method for checking, if a config-key is set in the "Swap-CI" configuration.
     *
     * @param   string $p_config_key
     *
     * @return  boolean
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function config_key_exists($p_config_key)
    {
        return array_key_exists($p_config_key, $this->get_config());
    }

    /**
     * Method for reloading the complete "swap CI" config.
     *
     * @return  isys_swapci_dao
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function reload_config()
    {
        self::$m_config = [];
        $l_res = $this->retrieve('SELECT * FROM isys_swapci_config;');

        while ($l_row = $l_res->get_row()) {
            if ($l_row['isys_swapci_config__type'] === C__TYPE__JSON) {
                $l_row['isys_swapci_config__value'] = isys_format_json::decode($l_row['isys_swapci_config__value']);
            }

            self::$m_config[$l_row['isys_swapci_config__key']] = $l_row['isys_swapci_config__value'];
        }

        return $this;
    }

    /**
     * Method for loading the whole configuration - or only one option.
     *
     * @param   string $p_option
     *
     * @return  array
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function get_config($p_option = null)
    {
        if (self::$m_config === null) {
            $this->reload_config();
        }

        if ($p_option === null) {
            return self::$m_config;
        }

        return self::$m_config[$p_option];
    }

    /**
     * Method for adding a new entry to our "swap archive".
     *
     * @param   int     $p_person_id
     * @param   string  $p_datetime
     * @param   int     $p_old_obj
     * @param   int     $p_new_obj
     * @param   array   $p_results
     *
     * @return  isys_swapci_dao
     * @throws  isys_exception_database
     */
    public function save_to_archive($p_person_id, $p_datetime = null, $p_old_obj = null, $p_new_obj = null, array $p_results = [])
    {
        $l_datetime = 'NOW()';

        if ($p_datetime !== null) {
            $l_datetime = $this->convert_sql_text($p_datetime);
        }

        $l_sql = 'INSERT INTO isys_swapci_archive SET 
            isys_swapci_archive__isys_obj__id = ' . $this->convert_sql_id($p_person_id) . ',
            isys_swapci_archive__datetime = ' . $l_datetime . ',
            isys_swapci_archive__old_obj = ' . $this->convert_sql_id($p_old_obj) . ',
            isys_swapci_archive__new_obj = ' . $this->convert_sql_id($p_new_obj) . ',
            isys_swapci_archive__results = ' . $this->convert_sql_text(isys_format_json::encode($p_results)) . ';';

        if ($this->update($l_sql) && $this->apply_update()) {
            return $this;
        }

        throw new isys_exception_database($this->get_database_component()->get_last_error_as_string());
    }

    /**
     * @param  int $p_id
     * @param  int $p_person_id
     * @param  int $p_old_obj
     * @param  int $p_new_obj
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function load_from_archive($p_id = null, $p_person_id = null, $p_old_obj = null, $p_new_obj = null)
    {
        $l_sql = 'SELECT *
			FROM isys_swapci_archive
			WHERE TRUE';

        if ($p_id !== null) {
            $l_sql .= ' AND isys_swapci_archive__id = ' . $this->convert_sql_id($p_id);
        }

        if ($p_person_id !== null) {
            $l_sql .= ' AND isys_swapci_archive__isys_obj__id = ' . $this->convert_sql_id($p_person_id);
        }

        if ($p_old_obj !== null) {
            $l_sql .= ' AND isys_swapci_archive__old_obj = ' . $this->convert_sql_id($p_old_obj);
        }

        if ($p_new_obj !== null) {
            $l_sql .= ' AND isys_swapci_archive__new_obj = ' . $this->convert_sql_id($p_new_obj);
        }

        return $this->retrieve($l_sql . ';');
    }
}
