<?php
/**
 * i-doit
 *
 * "Swap CI" Module initializer
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Component\Autoloader;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\Routing\Loader\PhpFileLoader;

if (isys_module_manager::instance()->is_active('swapci')) {
    \idoit\Psr4AutoloaderClass::factory()->addNamespace('idoit\Module\SwapCi', __DIR__ . '/src/');

    Autoloader::appendClassmap(require_once __DIR__ . '/classmap.php');

    // Handle add-on specific report views.
    isys_register::factory('additional-report-views')
        ->set(__DIR__ . '/reportview/isys_swapci_reportview_show_objects.class.php');

    // Connect a new method to the "beforeRender" signal from the navbar.
    isys_application::instance()->container->get('signals')
        ->connect('system.navbar.beforeAssignment', ['isys_module_swapci', 'add_swap_button']);

    isys_application::instance()->container->get('routes')
        ->addCollection((new PhpFileLoader(new FileLocator(__DIR__)))->load('config/routes.php'));
}
