<?php

namespace idoit\Module\SwapCi\Controller;

use Exception;
use isys_format_json;
use isys_swapci_swap;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;

class SwapController
{
    /**
     * @param Request $request
     *
     * @return Response
     */
    public function swap(Request $request): Response
    {
        try {
            $options = $request->request->all();

            if (is_string($options['categories'])) {
                $options['categories'] = isys_format_json::decode($options['categories'], true);
            }

            $results = (new isys_swapci_swap())
                ->init($options)
                ->swap()
                ->get_results();

            return new JsonResponse([
                'success' => true,
                'data'    => $results,
                'message' => ''
            ]);
        } catch (Exception $e) {
            return new JsonResponse([
                'success' => false,
                'data'    => null,
                'message' => $e->getMessage()
            ]);
        }
    }
}
