<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource\JDisc;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource\DataSource;
use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option\SelectOptionValue;
use isys_module_jdisc;

class JDiscModeDataSource implements DataSource
{
    /**
     * @param array $parameters
     * @return SelectOptionValue[]
     */
    public function getValues(array $parameters): array
    {
        return [
            new SelectOptionValue(
                (string) isys_module_jdisc::C__IMPORT_MODE__CREATE,
                'Append',
            ),
            new SelectOptionValue(
                (string) isys_module_jdisc::C__IMPORT_MODE__UPDATE,
                'Update',
            ),
            new SelectOptionValue(
                (string) isys_module_jdisc::C__IMPORT_MODE__OVERWRITE,
                'Overwrite',
            ),
            new SelectOptionValue(
                (string) isys_module_jdisc::C__IMPORT_MODE__UPDATE_NEW_DISCOVERY,
                'Update (newly discovered)',
            ),
            new SelectOptionValue(
                (string) isys_module_jdisc::C__IMPORT_MODE__OVERWRITE_NEW_DISCOVERY,
                'Overwrite (newly discovered)',
            ),
            new SelectOptionValue(
                (string) isys_module_jdisc::C__IMPORT_MODE__CREATE_ONLY_NEW_DEVICES,
                'Only create newly scanned devices',
            ),
            new SelectOptionValue(
                (string) isys_module_jdisc::C__IMPORT_MODE__UPDATE_EXISTING_ONLY,
                'Update (Existing)',
            ),
        ];
    }
}