<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\Invocation;

class CategoryEntryRankedInvocation extends Invocation
{
    public const TYPE = 'category-entry-ranked';

    /**
     * @param int $entryId
     * @param string $category
     * @param int $entryStatus
     * @param ObjectContext $context
     */
    public function __construct(
        private int $entryId,
        private string $category,
        private int $entryStatus,
        ObjectContext $context
    ) {
        $this->context = $context;
    }

    /**
     * @return int
     */
    public function getEntryId(): int
    {
        return $this->entryId;
    }

    /**
     * @return string
     */
    public function getCategory(): string
    {
        return $this->category;
    }

    /**
     * @return int
     */
    public function getEntryStatus(): int
    {
        return $this->entryStatus;
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        return 'Category entry is ranked';
    }
}