<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\Invocation;

use DateTime;
use idoit\Module\SyneticsFlows\Serialization\DateFormat;
use idoit\Module\SyneticsFlows\Serialization\Discriminator;
use isys_application;

#[Discriminator([
    'object' => ObjectContext::class,
    'context' => InvocationContext::class,
    'category' => CategoryContext::class
])]
class InvocationContext
{
    public function __construct(
        protected string $userId,
        #[DateFormat]
        protected DateTime $time,
    )
    {
    }

    public static function fromEnvironment(): InvocationContext
    {
        $session = isys_application::instance()->container->get('session');
        $userId = $session->get_userdata()['id'] ?? '';
        return new self($userId, new DateTime());
    }

    public function getUserId(): string
    {
        return $this->userId;
    }

    public function getTime(): DateTime
    {
        return $this->time;
    }

    /**
     * @param string $userId
     *
     * @return void
     */
    public function setUserId(string $userId): void
    {
        $this->userId = $userId;
    }
}
