<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\Invocation;

class ObjectCreatedInvocation extends Invocation
{
    public const TYPE = 'object-created';

    public function __construct(private ?string $title, ObjectContext $context)
    {
        $this->context = $context;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function __toString(): string
    {
        return 'Object is created';
    }
}