<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\InvocationMatcher;

use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\CategoryCreatedInvocation;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\Invocation;

class CategoryCreatedMatcher extends DaoMatcher
{
    protected function getExtraConditions(Invocation $invocation): array
    {
        if (!$invocation instanceof CategoryCreatedInvocation) {
            return [];
        }

        return [
            "JSON_EXTRACT(automation_trigger, '$.type') = 'category'",
            "JSON_EXTRACT(automation_trigger, '$.event') = 'category-created'",
            "(JSON_EXTRACT(automation_trigger, '$.category') is null OR JSON_EXTRACT(automation_trigger, '$.category') = 'null' OR JSON_SEARCH(automation_trigger, 'one', '{$invocation->getCategory()}', null, '$.category') is not null)",
        ];
    }

    public function supports(Invocation $invocation): bool
    {
        return $invocation instanceof CategoryCreatedInvocation;
    }
}