<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\InvocationMatcher;

use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\Invocation;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\ObjectCreatedInvocation;

class ObjectCreatedMatcher extends DaoMatcher
{
    protected function getExtraConditions(Invocation $invocation): array
    {
        if (!$invocation instanceof ObjectCreatedInvocation) {
            return [];
        }
        return [
            "JSON_EXTRACT(automation_trigger, \"$.type\") = 'object'",
            "JSON_EXTRACT(automation_trigger, \"$.objectEvent\") = 'created'"
        ];
    }

    public function supports(Invocation $invocation): bool
    {
        return $invocation instanceof ObjectCreatedInvocation;
    }
}
