<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\InvocationMatcher;

use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\Invocation;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\ObjectUpdatedInvocation;

class ObjectUpdatedMatcher extends DaoMatcher
{
    public function supports(Invocation $invocation): bool
    {
        return $invocation instanceof ObjectUpdatedInvocation;
    }

    protected function getExtraConditions(Invocation $invocation): array
    {
        if (!$invocation instanceof ObjectUpdatedInvocation) {
            return [];
        }

        return [
            "JSON_EXTRACT(automation_trigger, \"$.type\") = 'object'",
            "JSON_EXTRACT(automation_trigger, \"$.objectEvent\") = 'updated'",
        ];
    }
}
