<?php declare(strict_types=1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\TriggerType;

use idoit\Module\SyneticsFlows\Validation\Required;
use idoit\Module\SyneticsFlows\Validation\ValidationCallback;
use idoit\Module\SyneticsFlows\Validation\ValidationMessage;

class ObjectTriggerType extends TriggerType
{
    public function __construct(
        private ?array  $objectTypes = null,
        private ?string $objectTypeSelection = null,
        #[Required]
        private ?string $objectEvent = null,
        private ?array  $objectIds = null
    )
    {
    }

    public function getObjectTypes(): array
    {
        return $this->objectTypes;
    }

    public function getObjectTypeSelection(): ?string
    {
        return $this->objectTypeSelection;
    }

    public function getObjectTypeEvent(): ?string
    {
        return $this->objectEvent;
    }

    public function getObjectIds(): ?array
    {
        return $this->objectIds;
    }

    #[ValidationCallback]
    public function validate(array $path): array
    {
        $results = [];
        if ($this->objectTypeSelection == 'type' && empty($this->objectTypes)) {
            $results[] = new ValidationMessage([...$path, 'objectTypes'], 'LC__MODULE__SYNETICS_FLOWS__VALUE_REQUIRED');
        }

        if ($this->objectTypeSelection == 'objects' && empty($this->objectIds)) {
            $results[] = new ValidationMessage([...$path, 'objectIds'], 'LC__MODULE__SYNETICS_FLOWS__VALUE_REQUIRED');
        }

        return $results;
    }
}
