<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Dto;

use idoit\Module\SyneticsFlows\Serialization\Discriminator;
use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use idoit\Module\SyneticsFlows\Validation\Required;
use JsonSerializable;

#[Discriminator([
    'value' => ValueItem::class
])]
abstract class KeyValueItem implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        #[Required]
        protected ?string $key,
    )
    {
    }

    public function getKey(): ?string
    {
        return $this->key;
    }
}