<?php

namespace idoit\Module\SyneticsFlows\Export\Formatter;

class JsonFormatter implements ExportFormatterInterface
{
    public const FORMAT = 'json';
    public const MIME_TYPE = 'application/json';

    /**
     * @param array $automations
     *
     * @return string
     */
    public function format(array $automations): string
    {
        return json_encode($automations);
    }

    /**
     * @param string $format
     *
     * @return bool
     */
    public function support(string $format): bool
    {
        return $format === self::FORMAT;
    }
}