<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Model\AttributeDataExtractor\Type;

use idoit\Component\Property\Property;
use idoit\Module\Cmdb\Component\AttributeDataCollector\CollectorTypes\AbstractCollector;
use idoit\Module\Cmdb\Component\AttributeDataCollector\CollectorTypes\BrowserLocation as BrowserLocationCollector;
use idoit\Module\Cmdb\Component\AttributeDataCollector\CollectorTypes\BrowserObject as BrowserObjectCollector;
use idoit\Module\SyneticsFlows\Model\AttributeDataExtractor\ExtractorInterface;
use idoit\Module\SyneticsFlows\Model\Dto\AttributeData;
use idoit\Module\SyneticsFlows\Model\Dto\CiObject;
use idoit\Module\SyneticsFlows\Model\Dto\LocationObjectAttributeData;

class BrowserLocation implements ExtractorInterface
{
    /**
     * @param AbstractCollector $dataCollector
     *
     * @return bool
     */
    public function supports(AbstractCollector $dataCollector): bool
    {
        return $dataCollector instanceof BrowserLocationCollector;
    }

    /**
     * @param Property          $property
     * @param AbstractCollector $dataCollector
     * @param string|null       $entryId
     *
     * @return array
     * @throws \idoit\Module\Cmdb\Component\AttributeDataCollector\Exceptions\NoProperCollectorTypeFoundException
     */
    public function extract(Property $property, AbstractCollector $dataCollector, ?string $entryId = null): array
    {
        if (!$dataCollector instanceof BrowserLocationCollector) {
            return [];
        }

        $dao = \isys_cmdb_dao_location::instance(\isys_application::instance()->container->get('database'));
        $result = $dao->get_location_by_object_id($entryId !== null ? (int)$entryId: null);
        $data = [];
        while ($row = $result->get_row()) {
            if (!$row['isys_obj_type__container']) {
                continue;
            }
            $data[] = new LocationObjectAttributeData(
                (string)$row['isys_obj__id'],
                $row['isys_obj__title'],
                $row['isys_obj_type__id'],
                $row['isys_obj__status'],
                $row['isys_catg_location_list__parentid'],
            );
        }
        return $data;
    }
}
