<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Command;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\IdoitCommand;
use Symfony\Component\Console\Command\Command;

class WhitelistConverter implements CommandConverter
{
    public function __construct(private CommandConverter $innerConverter, private array $whitelist)
    {
    }

    public function convert(Command $command): ?IdoitCommand
    {
        if (!in_array($command->getName(), $this->whitelist, true)) {
            return null;
        }

        return $this->innerConverter->convert($command);
    }

    public function supports(Command $command): bool
    {
        return true;
    }
}