<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionResult;

class CliErrorExecutionResult extends ExecutionResult implements ErrorExecutionInterface
{
    public function __construct(private int $exitCode, private string $output)
    {
    }

    public function getOutput(): string
    {
        return $this->output;
    }

    public function getExitCode(): int
    {
        return $this->exitCode;
    }

    public function __toString(): string
    {
        return "Command failed: " . $this->exitCode;
    }
}