<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\Invocation;

class CategoryUpdatedInvocation extends Invocation
{
    public const TYPE = 'category-updated';

    public function __construct(private ?string $category, private ?string $categoryType, private ?array $attributes, ObjectContext $context)
    {
        $this->context = $context;
    }

    public function getCategory(): ?string
    {
        return $this->category;
    }

    public function getCategoryType(): ?string
    {
        return $this->categoryType;
    }

    public function getAttributes(): ?array
    {
        return $this->attributes;
    }

    public function __toString(): string
    {
        return "{$this->category} has been updated";
    }
}
