<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\Invocation;

use DateTime;

class ObjectContext extends InvocationContext
{
    public function __construct(protected string $objectId, protected string $objectType, ?string $userId = null, ?DateTime $time = null)
    {
        $context = InvocationContext::fromEnvironment();
        parent::__construct($userId ?? $context->getUserId(), $time ?? $context->getTime());
    }

    public function getObjectId(): string
    {
        return $this->objectId;
    }

    public function getObjectType(): string
    {
        return $this->objectType;
    }
}