<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\InvocationMatcher;

use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\CategoryEntryRankedInvocation;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\Invocation;

class CategoryEntryRankedMatcher extends DaoMatcher
{
    /**
     * @param Invocation $invocation
     * @return array|string[]
     */
    protected function getExtraConditions(Invocation $invocation): array
    {
        if (!$invocation instanceof CategoryEntryRankedInvocation) {
            return [];
        }

        return [
            "JSON_UNQUOTE(JSON_EXTRACT(automation_trigger, '$.type')) = 'category'",
            "JSON_UNQUOTE(JSON_EXTRACT(automation_trigger, '$.event')) = 'entry-ranked'",
            "(JSON_UNQUOTE(JSON_EXTRACT(automation_trigger, '$.category')) IN (NULL, 'null') OR JSON_SEARCH(automation_trigger, 'one', '{$invocation->getCategory()}', null, '$.category') is not null)",
            "(JSON_UNQUOTE(JSON_EXTRACT(automation_trigger, '$.status')) IN (NULL, 'null') OR JSON_SEARCH(automation_trigger, 'one', '{$invocation->getEntryStatus()}', null, '$.status') is not null)",
        ];
    }

    /**
     * @param Invocation $invocation
     * @return bool
     */
    public function supports(Invocation $invocation): bool
    {
        return $invocation instanceof CategoryEntryRankedInvocation;
    }
}
