<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\InvocationMatcher;

use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\Invocation;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\ObjectPurgedInvocation;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\ObjectRankedInvocation;

class ObjectPurgedMatcher extends DaoMatcher
{
    public function supports(Invocation $invocation): bool
    {
        return $invocation instanceof ObjectPurgedInvocation;
    }

    protected function getExtraConditions(Invocation $invocation): array
    {
        if (!$invocation instanceof ObjectPurgedInvocation) {
            return [];
        }

        return [
            "JSON_UNQUOTE(JSON_EXTRACT(automation_trigger, \"$.type\")) = 'object'",
            "JSON_UNQUOTE(JSON_EXTRACT(automation_trigger, \"$.objectEvent\")) = 'purged'",
        ];
    }
}
