<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\TriggerType;

use DateTime;
use DateTimeImmutable;
use DateTimeZone;
use idoit\Module\SyneticsFlows\Serialization\Discriminator;
use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use idoit\Module\SyneticsFlows\Serialization\Serializer;
use JsonSerializable;

#[Discriminator([
    'button' => ButtonTriggerType::class,
    'schedule' => ScheduleTriggerType::class,
    'object' => ObjectTriggerType::class,
    'category' => CategoryTriggerType::class,
    'api-call' => ApiCallTriggerType::class,
])]
abstract class TriggerType implements JsonSerializable
{
    use SerializableTrait;

    /**
     * @return DateTimeImmutable|null
     */
    public function getNextStartDate(): ?DateTimeImmutable
    {
        return new DateTimeImmutable("now");
    }
}
