<?php declare(strict_types = 1);

namespace idoit\Module\Synetics_flows\Console\Command;

use idoit\Console\Command\AbstractCommand;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\TimeInvocation;
use idoit\Module\SyneticsFlows\Automation\TriggerFacade;
use isys_application;
use isys_module_manager;
use isys_module_synetics_flows;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputDefinition;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class TimeTriggerCommand extends AbstractCommand
{
    const NAME = 'flows:time-trigger';

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        isys_application::instance()->container->get('moduleManager')->processAddonLicenses();

        if (!isys_module_manager::instance()->is_active('synetics_flows')) {
            $output->writeln('Flows add-on is not active');

            return Command::FAILURE;
        }

        if (!isys_module_manager::instance()->is_installed('synetics_flows')) {
            $output->writeln('Flows add-on is not installed');

            return Command::FAILURE;
        }

        $service = TriggerFacade::getService();
        $result = $service->invoke(new TimeInvocation());
        return Command::SUCCESS;
    }

    public function getCommandName(): string
    {
        return self::NAME;
    }

    public function getCommandDescription(): string
    {
        return 'Trigger execution of time automations';
    }

    public function getCommandDefinition(): InputDefinition
    {
        return new InputDefinition();
    }

    public function isConfigurable(): bool
    {
        return true;
    }

    public function getCommandUsages(): array
    {
        return [];
    }
}
