<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Dto;

use idoit\Module\SyneticsFlows\Dto\Criteria\AndCriteria;
use idoit\Module\SyneticsFlows\Dto\Criteria\EqCriteria;
use idoit\Module\SyneticsFlows\Dto\Criteria\GreaterOrEqualThanCriteria;
use idoit\Module\SyneticsFlows\Dto\Criteria\GreaterThanCriteria;
use idoit\Module\SyneticsFlows\Dto\Criteria\InCriteria;
use idoit\Module\SyneticsFlows\Dto\Criteria\LessOrEqualThanCriteria;
use idoit\Module\SyneticsFlows\Dto\Criteria\LessThanCriteria;
use idoit\Module\SyneticsFlows\Dto\Criteria\LikeCriteria;
use idoit\Module\SyneticsFlows\Dto\Criteria\NotEqCriteria;
use idoit\Module\SyneticsFlows\Dto\Criteria\NotInCriteria;
use idoit\Module\SyneticsFlows\Dto\Criteria\NotLikeCriteria;
use idoit\Module\SyneticsFlows\Dto\Criteria\OrCriteria;
use idoit\Module\SyneticsFlows\Dto\Criteria\QueryCriteria;
use idoit\Module\SyneticsFlows\Dto\Criteria\RangeCriteria;
use idoit\Module\SyneticsFlows\Serialization\Discriminator;
use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

#[Discriminator([
    'and' => AndCriteria::class,
    'or' => OrCriteria::class,
    'query' => QueryCriteria::class,
    'eq' => EqCriteria::class,
    'neq' => NotEqCriteria::class,
    'like' => LikeCriteria::class,
    'not_like' => NotLikeCriteria::class,
    'lt' => LessThanCriteria::class,
    'lte' => LessOrEqualThanCriteria::class,
    'gt' => GreaterThanCriteria::class,
    'gte' => GreaterOrEqualThanCriteria::class,
    'in' => InCriteria::class,
    'not_in' => NotInCriteria::class,
    'range' => RangeCriteria::class,
])]
abstract class Criteria implements JsonSerializable
{
    use SerializableTrait;
}