<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Dto\Criteria;

use idoit\Module\SyneticsFlows\Validation\Required;

abstract class ArrayCriteria extends FieldCriteria
{
    protected const COMPARISON_OPERATOR = '';

    public function __construct(
        ?string $field = null,
        #[Required]
        protected array $value = []
    )
    {
        parent::__construct($field);
    }

    public function getValue(): array
    {
        return $this->value;
    }

    /**
     * @return string
     */
    public function getComparisonOperator(): string
    {
        return static::COMPARISON_OPERATOR;
    }

    public function prepareReportManagerCondition(): array
    {
        return [
            [
                'category' => $this->getCategory(),
                'property' => $this->getProperty(),
                'comparison' => $this->getComparisonOperator(),
                'value' => empty($this->getValue()) ? null : $this->getValue(),
            ]
        ];
    }
}
