<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Model\Dto;

use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

class IdoitImage implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(private string $path, private string $name)
    {
    }

    public function getPath(): string
    {
        return $this->path;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function __toString(): string
    {
        return json_encode($this->jsonSerialize(), JSON_PRETTY_PRINT);
    }
}
