<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Template\TemplateVariables;

use JsonSerializable;

class PropertyValueTemplate implements JsonSerializable
{
    public function __construct(private mixed $value, private mixed $id)
    {
    }

    public function getValue(): mixed
    {
        return $this->value;
    }

    public function getId(): mixed
    {
        return $this->id;
    }

    public function __toString(): string
    {
        return (string)$this->value;
    }

    public function jsonSerialize()
    {
        return $this->value;
    }
}