<?php

namespace idoit\Module\SyneticsJdisc\Controller;

use idoit\Module\SyneticsJdisc\Graphql\Connector;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;

class TokenController extends AbstractController
{
    /**
     * @return Response
     */
    public function get(int $id): Response
    {
        $response = new JsonResponse();

        try {
            $connector = Connector::instance($id);
            $connector->connect();

            $token = $connector->getToken();

            $data = [
                'accessToken'  => $token->getAccessToken(),
                'refreshToken' => $token->getRefreshToken(),
            ];

            $response->setData($data);
        } catch (\Throwable $e) {
            $response->setData(['error' => $e->getMessage()]);
            $response->setStatusCode(Response::HTTP_INTERNAL_SERVER_ERROR);
        }

        return $response;
    }

}
