<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type ChartTitleOptionsInput
 * The chart title options * @property null|ChartLeftOptionEnum $left = null Distance between title component and the left side of the container. left value can be 'left', 'center', or 'right'. If the left value is set to be 'left', 'center', or 'right', then the component will be aligned automatically based on position.
 * @property null|bool $show = null Set this false to prevent the title from showing
 * @property null|string $subtext = null Subtitle text, supporting for \n for newlines.
 * @property null|string $text = null The title
 * @property null|ChartTopOptionEnum $top = null Distance between title component and the top side of the container. top value can be 'top', 'middle', or 'bottom'. If the top value is set to be 'top', 'middle', or 'bottom', then the component will be aligned automatically based on position.
 */
final class ChartTitleOptionsInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'left') {
            return new ChartLeftOptionEnum($value);
        }

        if ($name === 'top') {
            return new ChartTopOptionEnum($value);
        }

        return $value;
    }
}