<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type DeviceManagementMutation
 */
final class DeviceManagementMutationType implements AutoGenerationInterface
{
    /**
     * Assign the selected devices to matching device groups.

Required permissions: ManageDevices
     */
    public bool $assignDevicesToGroups;
    /**
     * Assign the selected devices to matching device groups as async call.

Required permissions: ManageDevices
     */
    public ?DefaultProgressInfoType $assignDevicesToGroupsAsync = null;
    /**
     * Deletes a device. Returns <true> if succeeded.
 The comment is being written to the device deletion log as deletion comment!

Required permissions: ManageDevices
     */
    public bool $deleteDevice;
    /**
     * Deletes devices from the database. Returns a list of devices that could not be found or an empty list if succeeded. (sync call).
The comment is being written to the device deletion log as deletion comment!

Required permissions: ManageDevices
     * @var null|iterable
     */
    public ?iterable $deleteDevices = null;
    /**
     * Deletes devices from the database. Returns a progress object that the client can poll for the task status. (async call)
The comment is being written to the device deletion log as deletion comment!

Required permissions: ManageDevices
     */
    public ?DeviceDeletionOperationResultType $deleteDevicesAsync = null;
    /**
     * disables a set of discovery protocols for the selected devices

Required permissions: ChangeDiscoverySettings
     * @var null|iterable
     */
    public ?iterable $disableDiscoveryProtocols = null;
    /**
     * disables a set of discovery protocols for the selected devices

Required permissions: ChangeDiscoverySettings
     */
    public ?DefaultProgressInfoType $disableDiscoveryProtocolsAsync = null;
    /**
     * Initiates a discovery for the given hostname or IP address. Upon failure, the response describes the reason.

Required permissions: DiscoverSingleDevice
     * @var null|iterable
     */
    public ?iterable $discoverNow = null;
    /**
     * Initiates a discovery for the given hostname(s) or IP address(es). Returns a progress object that the client can poll for the task status. (async call)

Required permissions: DiscoverSingleDevice
     */
    public ?DiscoverNowOperationResultType $discoverNowAsync = null;
    /**
     * Gets the credential management object which is used to modify accounts/passwords.
     */
    public ?DeviceCredentialManagementType $credentials = null;
    /**
     * Refreshes end of life support for the given device list. Returns a progress object that the client can poll for the task status. (async call)

Required permissions: ManageDevices
     */
    public ?RefreshEndOfLifeSupportOperationResultType $refreshEndOfLifeSupportAsync = null;
    /**
     * Refreshes support entitlements for the given device list. Returns a progress object that the client can poll for the task status. (async call)

Required permissions: ControlDiscovery, DiscoverSingleDevice
     */
    public ?RefreshSupportEntitlementsOperationResultType $refreshSupportEntitlementsAsync = null;
}