<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type Devices
 * This type provides device related queries */
final class DevicesType implements AutoGenerationInterface
{
    /**
     * Find all devices

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findAll = null;
    /**
     * Find basic info of all devices

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findAllBasicInfo = null;
    /**
     * Find device by id

Required permissions: ViewData
     */
    public ?DeviceType $findByID = null;
    /**
     * Find devices by id

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findByIds = null;
    /**
     * Find devices by an integration id and a foreignId. Integrations are being used when import JDisc Discovery data into other solutions like CMDB solutions

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findByIntegrationIdAndForeignKey = null;
    /**
     * Find devices by name. The default for caseSensitive is TRUE.

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findByName = null;
    /**
     * Find devices by operating system family

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findByOperatingSystemFamily = null;
    /**
     * Find devices by operating system version

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findByOperatingSystemVersion = null;
    /**
     * Find devices by its role

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findByRole = null;
    /**
     * Find devices by type

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findByType = null;
    /**
     * Finds all devices where type matches one of the types passed as argument.

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findByTypes = null;
    /**
     * Finds all devices where type matches any of the types passed as argument or its children.

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findByTypesHierarchy = null;
    /**
     * Finds all devices which have IP addresses within a set of networks defined by CIDR addresses.

A CIDR address is of the form "<base address>/bits". For instance something like "192.168.178.0/24" for the network "192.168.178.0" with the subnet mask "255.255.255.0".

The IP4 network that is defined by the CIDR does not need to necessarily exist as a network in the database!

The activeOnly indicates whether to search only for IP addresses on active interfaces.
When the activeOnly is FALSE, then we are also looking on interfaces with a status other than 'up'.
The default for the activeOnly is TRUE

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findDevicesByCIDRs = null;
    /**
     * Finds all devices with an IP address.
The activeOnly indicates whether to search only for IP addresses on active interfaces.
When the activeOnly is FALSE, then we are also looking on interfaces with a status other than 'up'.
The default for the activeOnly is TRUE

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findDevicesByIPAddress = null;
    /**
     * Find devices that are part of an IP4 network. Note: A device can be part of multiple networks!

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findDevicesInIP4Network = null;
    /**
     * Find devices that are part of an IP6 network. Note: A device can be part of multiple networks!

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findDevicesInIP6Network = null;
    /**
     * Find devices with a physical address (mac address or WWN).

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findDevicesWithPhysicalAddress = null;
    /**
     * Find devices with operating system family 'Windows' and not a server OS (osVersion contains 'Server')

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findWindowsClients = null;
    /**
     * Find devices with operating system family 'Windows' and a server OS (osVersion contains 'Server')

Required permissions: ViewData
     * @var null|iterable
     */
    public ?iterable $findWindowsServers = null;
}