<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type EndOfLifeSupportInput
 * This object contains information about the EndOfLife.date Support. * @property mixed $endOfActiveSupport = null The date when general active support for this version ends, meaning regular updates and maintenance will no longer be provided after this date.
 * @property mixed $endOfSecuritySupport = null The date when general security support for this version ends.
 * @property mixed $extendedEndOfSupport = null The end date for extended support, indicating when any additional, often limited, post-EOL support will no longer be available.
 * @property null|string $id = null The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
 * @property mixed $latestReleaseDate = null The release date of the latest product version, indicating when the most current version was made publicly available.
 * @property null|string $latestVersion = null The most recent version number available for the product, providing users with the latest stable release information.
 * @property null|string $link = null A URL linking to more detailed information about the product or specific version, such as official documentation or release notes.
 * @property null|bool $lts = null Indicates whether this version has Long-Term Support (LTS). For certain versions, this attribute is represented as a Boolean, where true denotes LTS support, while other versions may use a Date to indicate the specific start date of LTS.
 * @property mixed $ltsDate = null Provides the date of Long-Term Support (LTS) initiation if applicable. When the LTS information is represented as a Date, it specifies the start of the extended support period with stability and security updates.
 * @property null|string $name = null The version name or codename as specified in endoflife.date, often used in releases to identify versions in addition to version numbers.
 * @property null|string $productName = null The name of the product as specified in endoflife.date, identifying the software or OS for which lifecycle information is provided.
 * @property mixed $release = null The official release date of this version, marking when it was first made available to the public.
 * @property null|string $version = null The version number of the product as specified in endoflife.date, indicating the specific release version.
 */
final class EndOfLifeSupportInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        return $value;
    }
}