<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type IP4NetworkInput
 * An IP4 network object holding the IP base address, subnet mask and the name * @property null|iterable|DeviceInputInputType[] $devices = null The list of devices belonging to this network.
 * @property null|DirectoryInputInputType $directory = null The directory of the IPv4 network.
 * @property mixed $firstAddress = null The IPv4 network's first IP address.
 * @property mixed $lastAddress = null The IPv4 network's last IP address.
 * @property null|string $location = null The IPv4 network's location.
 * @property null|string $name = null The IPv4 network's name.
 * @property null|bool $nameManuallyConfigured = null A flag that indicates whether the network's name has been configured manually or whether it has been discovered (e.g. via AD).
 * @property mixed $networkBaseAddress = null The IPv4 network's base address.
 * @property null|IP4NetworkInputInputType $parentNetwork = null A network's parent network (if it exists).
 * @property mixed $subnetMask = null The IPv4 network's subnet mask.
 * @property null|iterable|IP4TransportInputInputType[] $transports = null The list of IP4 transports associated with this network.
 * @property null|NetworkTypeEnum $type = null The network type of the IPv4 network.
 */
final class IP4NetworkInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'devices') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        if ($name === 'directory') {
            return new DirectoryInputInputType($value);
        }

        if ($name === 'parentNetwork') {
            return new IP4NetworkInputInputType($value);
        }

        if ($name === 'transports') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new IP4TransportInputInputType($v)); })($value);
        }

        if ($name === 'type') {
            return new NetworkTypeEnum($value);
        }

        return $value;
    }
}