<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type IssuedClientAccessLicenseInput
 * An issued client access license (CAL) * @property null|AccountInputInputType $account = null The account associated with this issued client access license when found in our database
 * @property null|string $accountName = null The account  name associated with this issued client access license.
 * @property null|string $computerName = null The computer name associated with this issued client access license.
 * @property mixed $creationTime = null The time when the application was detected for the first time.
 * @property null|DeviceInputInputType $device = null The device associated with this issued client access license when found in our database
 * @property mixed $expirationDate = null The issued CAL license expiration date.
 * @property null|string $id = null The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
 * @property mixed $issueDate = null The issued CAL license issue date.
 * @property null|int $licenseId = null The CAL license id
 * @property null|OperatingSystemInputInputType $operatingSystem = null Gets the operating system for this client access license
 * @property null|ClientAccessLicenseProductSubTypeEnum $productSubtype = null The CAL product subtype
 * @property null|ClientAccessLicenseProductTypeEnum $productType = null The CAL product type
 * @property null|ServiceInputInputType $service = null Gets the service for this client access license
 * @property null|ClientAccessLicenseStatusEnum $status = null The CAL license status
 * @property null|string $version = null The CAL version
 */
final class IssuedClientAccessLicenseInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'account') {
            return new AccountInputInputType($value);
        }

        if ($name === 'device') {
            return new DeviceInputInputType($value);
        }

        if ($name === 'operatingSystem') {
            return new OperatingSystemInputInputType($value);
        }

        if ($name === 'productSubtype') {
            return new ClientAccessLicenseProductSubTypeEnum($value);
        }

        if ($name === 'productType') {
            return new ClientAccessLicenseProductTypeEnum($value);
        }

        if ($name === 'service') {
            return new ServiceInputInputType($value);
        }

        if ($name === 'status') {
            return new ClientAccessLicenseStatusEnum($value);
        }

        return $value;
    }
}