<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type KubernetesClusterAccessInput
 * This object contains information about the Kubernetes Cluster Access information. * @property null|string $comment = null A Kubernetes cluster access configuration comment
 * @property null|AccountInputInputType $configFile = null The Kubernetes config file stored in the password part of the account when a kube.conf file is used
 * @property null|bool $enabled = null Is the discovery for this cluster enabled?
 * @property null|string $id = null The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
 * @property null|string $ipOrHostname = null The Kubernetes cluster IP or hostname when ServiceAccount token access is used. Otherwise, the server address is part of the .conf file.
 * @property null|string $name = null The Kubernetes cluster access configuration name
 * @property null|int $port = null The Kubernetes cluster TCP/IP port when ServiceAccount token access is used. Otherwise, the port is part of the .conf file.
 * @property null|AccountInputInputType $tokenAccount = null The Kubernetes service account access token when a token based access is used
 */
final class KubernetesClusterAccessInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'configFile') {
            return new AccountInputInputType($value);
        }

        if ($name === 'tokenAccount') {
            return new AccountInputInputType($value);
        }

        return $value;
    }
}