<?php

namespace idoit\Module\SyneticsJdisc\Model;

use idoit\Module\SyneticsJdisc\Helper\SSEMessenger;

/**
 * Class JDiscCommandQueue
 *
 * Manages the JDisc command queue.
 *
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 * @author    Paul Kolbovich <pkolbovich@i-doit.org>
 */
class JDiscCommandQueue extends CommandQueue
{
    /**
     * @return void
     */
    public function processCommands(): void
    {
        $language = \isys_application::instance()->container->get('language');
        $sse = SSEMessenger::getInstance();

        while ($command = $this->dequeue()) {
            $this->updateStatus($command['isys_command_queue__id'], self::STATUS_COMPLETED);

            if ($command['isys_command_queue__command'] === 'pause') {
                $command = $this->handlePause();
            }
            if ($command['isys_command_queue__command'] === 'cancel') {
                $sse->sendEndMessage($language->get('LC__MODULE__JDISC__IMPORT__TERMINATED_BY_USER'));

                // @todo do we need to clear the queue?
                exit;
            }
            if ($command['isys_command_queue__command'] === 'continue') {
                $sse->sendContinueMessage();
            }
        }
    }

    /**
     * @return array
     */
    private function handlePause(): array
    {
        $language = \isys_application::instance()->container->get('language');
        $sse = SSEMessenger::getInstance();

        $tenantSettings = \isys_application::instance()->container->get('settingsTenant');
        $maxImportPause = (int) $tenantSettings->get('jdisc.max_pause_time_before_action', 15);
        $maxImportPause = $maxImportPause > 1 ? $maxImportPause : 1;
        $maxImportPause = strtotime("+{$maxImportPause} minutes");

        $afterPauseAction = $tenantSettings->get('jdisc.after_pause_action', 'cancel') === 'cancel' ? 'cancel' : 'continue';

        $actionMessage = $afterPauseAction === 'cancel'
            ? $language->get(
                'LC__UNIVERSAL__BUTTON_CANCEL',
                'Cancel'
            )
            : $language->get(
                'LC__UNIVERSAL__BUTTON_CONTINUE',
                'Continue'
            );

        $sse->sendPauseMessage(
            $maxImportPause,
            $language->get(
                'LC__MODULE__JDISC__IMPORT__PAUSE_MESSAGE',
                [$actionMessage]
            )
        );

        while (time() < $maxImportPause) {
            sleep($this->minCheckInterval);
            if ($command = $this->dequeue()) {
                $this->updateStatus($command['isys_command_queue__id'], self::STATUS_COMPLETED);
                if ($command['isys_command_queue__command'] === 'continue' || $command['isys_command_queue__command'] === 'cancel') {
                    return $command;
                }
            }
        }

        // @todo write to import log that max pause was reached

        // cancel on maxPause reached
        return [
            'isys_command_queue__command' => $afterPauseAction,
        ];
    }
}
