<?php

namespace idoit\Module\SyneticsJdisc\View;

abstract class AbstractEntryView extends AbstractView
{
    private ?int $id = null;

    /**
     * @var array
     */
    private array $validationErrors = [];

    /**
     * @param int|null $id
     *
     * @return $this
     */
    public function setId(?int $id): static
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param array $validationErrors
     *
     * @return $this
     */
    public function setValidationErrors(array $validationErrors): self
    {
        $this->validationErrors = $validationErrors;
        return $this;
    }

    /**
     * @return bool
     */
    public function hasValidationErrors(): bool
    {
        return !empty(array_filter($this->validationErrors, fn ($item) => $item > 0));
    }

    /**
     * @return array
     */
    public function getValidationErrors(): array
    {
        return $this->validationErrors;
    }

    /**
     * @param string|null $key
     *
     * @return void
     */
    public function unsetValidationError(?string $key = null): void
    {
        if ($key) {
            unset($this->validationErrors[$key]);
            return;
        }
        $this->validationErrors = [];
    }
}
