<?php

namespace idoit\Module\SyneticsJdisc\View;

use idoit\Module\SyneticsJdisc\Model\JDiscServerDao;
use isys_auth;
use isys_auth_system;
use isys_component_template_navbar;
use isys_module_synetics_jdisc;
use Symfony\Component\HttpFoundation\Response;

class DiscoveryServer extends AbstractEntryView
{
    private array $validationErrors = [];
    private JDiscServerDao $dao;

    public function __construct()
    {
        parent::__construct();
        $this->dao = new JDiscServerDao();
    }

    /**
     * @return static
     * @throws \Exception
     */
    public static function factory(): static
    {
        $instance = new static();
        $instance->template->assign('content_title', $instance->language->get('LC__JDISC__TREE__DISCOVERY_SERVER'));
        return $instance;
    }

    /**
     * @return JDiscServerDao
     */
    public function getDao(): JDiscServerDao
    {
        return $this->dao;
    }

    /**
     * @return void
     */
    private function loadNavbar(): void
    {
        $navbar = isys_component_template_navbar::getInstance();

        $editRight = isys_auth_system::instance()
            ->is_allowed_to(isys_auth::EDIT, 'JDISC/' . C__MODULE__JDISC . '9');

        $onClick = "document.isys_form.sort.value=''; document.isys_form.navMode.value=this.getAttribute('data-navmode'); $('isys_form').submit();";

        switch ($this->getMode()) {
            case C__NAVMODE__NEW:
                $navbar
                    ->set_active(true, C__NAVBAR_BUTTON__SAVE)
                    ->set_js_onclick($onClick, C__NAVBAR_BUTTON__SAVE)
                    ->set_active(true, C__NAVBAR_BUTTON__CANCEL)
                    ->set_js_onclick($onClick, C__NAVBAR_BUTTON__CANCEL)
                    ->set_active(false, C__NAVBAR_BUTTON__EDIT)
                    ->set_active(false, C__NAVBAR_BUTTON__NEW);
                break;
            case C__NAVMODE__EDIT:
                $navbar
                    ->set_active(true, C__NAVBAR_BUTTON__SAVE)
                    ->set_js_onclick($onClick, C__NAVBAR_BUTTON__SAVE)
                    ->set_active(true, C__NAVBAR_BUTTON__CANCEL)
                    ->set_js_onclick($onClick, C__NAVBAR_BUTTON__CANCEL)
                    ->set_active(false, C__NAVBAR_BUTTON__EDIT)
                    ->set_active(false, C__NAVBAR_BUTTON__NEW);
                break;
            default:
                $navbar
                    ->set_active($editRight, C__NAVBAR_BUTTON__EDIT)
                    ->set_js_onclick($onClick, C__NAVBAR_BUTTON__EDIT)
                    ->set_visible(true, C__NAVBAR_BUTTON__EDIT)
                    ->set_active(false, C__NAVBAR_BUTTON__NEW);
                break;
        }

        $navbar->set_active(false, C__NAVBAR_BUTTON__PURGE)
            ->set_visible(false, C__NAVBAR_BUTTON__ARCHIVE)
            ->set_visible(false, C__NAVBAR_BUTTON__DELETE)
            ->set_visible(false, C__NAVBAR_BUTTON__PURGE)
            ->set_visible(false, C__NAVBAR_BUTTON__RECYCLE);
    }

    /**
     * @return void
     */
    private function loadContent(): void
    {
        $properties = $this->dao->getProperties();
        $validationErrors = $data = [];

        $data = $this->dao->getJdiscDao()->transformDataByProperties($properties, $_POST);
        if ($this->getMode() === C__NAVMODE__SAVE) {
            $this->validationErrors = $this->dao->validateData($data);

            if (!$this->getId()) {
                unset($this->validationErrors['id']);
            }

            if (!empty(array_filter($this->validationErrors, fn ($item) => $item > 0))) {
                $this->setMode(C__NAVMODE__EDIT);
                $this->template->activate_editmode();
                $this->render();
                return;
            }
        }

        if ($this->getId() > 0) {
            $data = $this->dao->getConfiguration($this->getId());
        }
        $this->template->assign('id', $this->getId() ?? null);
        $this->template->smarty_tom_add_rules('tom.content.bottom.content', $this->dao->getJdiscModule()->prepare_user_data_assignment($properties, $data, $this->validationErrors));
    }

    /**
     * @return Response
     * @throws \Exception
     */
    public function render(): Response
    {
        $this->loadNavbar();
        $this->loadContent();

        return self::getResponse()
            ->setTemplate('contentbottomcontent', isys_module_synetics_jdisc::getPath() . 'templates/discovery-server.tpl');
    }
}
