<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type Certificates
 * This type provides certificate related queries */
final class CertificatesType implements AutoGenerationInterface
{
    /**
     * Find all certificates
     * @var null|iterable
     */
    public ?iterable $findAll = null;
    /**
     * Find certificate by its id
     */
    public ?CertificateType $findById = null;
    /**
     * Find all certificates by issuer
     * @var null|iterable
     */
    public ?iterable $findByIssuer = null;
    /**
     * Find all certificates by issuer
     * @var null|iterable
     */
    public ?iterable $findByIssuerAndSubject = null;
    /**
     * Find all certificates by subject pattern. '*' stands for any character(s) and '?' for any single character (similar to directory wildcards on Windows).
     * @var null|iterable
     */
    public ?iterable $findByIssuerAndSubjectPattern = null;
    /**
     * Find all certificates by issuer pattern. '*' stands for any character(s) and '?' for any single character (similar to directory wildcards on Windows).
     * @var null|iterable
     */
    public ?iterable $findByIssuerPattern = null;
    /**
     * Find all certificates by oid
     * @var null|iterable
     */
    public ?iterable $findByOid = null;
    /**
     * Find all certificates by subject
     * @var null|iterable
     */
    public ?iterable $findBySubject = null;
    /**
     * Find all certificates by subject pattern. '*' stands for any character(s) and '?' for any single character (similar to directory wildcards on Windows).
     * @var null|iterable
     */
    public ?iterable $findBySubjectPattern = null;
    /**
     * Find all certificates that expire after a given date
     * @var null|iterable
     */
    public ?iterable $findExpiringAfterCertificates = null;
    /**
     * Find all certificates that expire before a given date
     * @var null|iterable
     */
    public ?iterable $findExpiringBeforeCertificates = null;
}