<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type ComputerAccountInput
 * A computer account object within Microsoft's Active Directory * @property null|string $description = null The description.
 * @property null|DirectoryInputInputType $directory = null The associated directory object.
 * @property null|HostnameInputInputType $hostname = null The associated hostname object.
 * @property mixed $lastLogonTime = null The last logon time for this computer account. This is not the logon time for a user logging on. It is the logon time when the computer registers itself on the domain controller.
 * @property null|string $uniqueId = null The computer account's unique id.
 */
final class ComputerAccountInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'directory') {
            return new DirectoryInputInputType($value);
        }

        if ($name === 'hostname') {
            return new HostnameInputInputType($value);
        }

        return $value;
    }
}