<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type DeviceInput
 * The device object specifies a single physical or virtual device together with all its properties. * @property null|iterable|DeviceAccountAssignmentInputInputType[] $accountAssignments = null The device account assignments
 * @property null|iterable|DeviceArrayAttributeInputInputType[] $arrayAttributes = null Gets all array attributes for this device (simple attached attributes or custom attributes)
 * @property null|string $assetTag = null A device's asset tag
 * @property null|iterable|DeviceAttributeInputInputType[] $attachedAttributes = null Gets all attributes for this device (simple attached attributes or custom attributes)
 * @property null|BiosInputInputType $bios = null A device's BIOS
 * @property null|iterable|ClusterInputInputType[] $clusters = null The clusters which this device belongs to
 * @property null|iterable|ComputerAccountDeviceAssignmentInputInputType[] $computerAccountAssignment = null The associated computer account assigment from Microsoft's Active Directory.
 * @property null|string $computername = null A device's NetBIOS computer name
 * @property mixed $creationTime = null The time when the device was scanned for the first time.
 * @property mixed $databaseDuration = null The duration in milliseconds that were required to write this device's data to the database
 * @property null|iterable|DeviceGroupInputInputType[] $deviceGroups = null Gets the list of all devices which are assigned to this group.
 * @property null|iterable|EventInputInputType[] $diagnosticEvents = null The list of all diagnostic events.

Diagnostic events help users to identify discovery issues that result from missing configurations, protocols or issues
with the device.
 * @property null|DirectoryInputInputType $directory = null The directory item that this device belongs to.
 * @property mixed $discoveryDuration = null The duration in milliseconds that were required to discover this device
 * @property mixed $discoveryTime = null The last discovery timestamp. This is the timestamp of the current data.
 * @property null|iterable|DiskPartitionInputInputType[] $diskPartitions = null The list of disk partitions.
 * @property null|iterable|PhysicalDiskSlotInputInputType[] $diskSlots = null The list of physical disk slots.
 * @property null|iterable|EventInputInputType[] $events = null The list of all events like shutdown, reboot, and others.
 * @property null|string $hwVersion = null A device's hardware version
 * @property null|string $id = null The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
 * @property null|iterable|IscsiPortInputInputType[] $iscsiInitiators = null The list of iSCSI initiator ports.
 * @property null|iterable|IscsiPortInputInputType[] $iscsiPorts = null The list of iSCSI ports.
 * @property null|iterable|IscsiPortInputInputType[] $iscsiTargets = null The list of iSCSI target ports.
 * @property null|iterable|IssuedClientAccessLicenseInputInputType[] $issuedClientAccessLicenses = null Gets the list of issued client access licenses for this device
 * @property null|iterable|JavaRiskInputInputType[] $javaRisks = null Gets the list of all Java license risks
 * @property mixed $lastSeenTime = null The last seen timestamp. This timestamp defines when the device has been seen the last time directly or indirectly (e.g. via a VMware VCenter installation).
 * @property mixed $lastSupportEntitlementTime = null The time when the support entitlements have been read for the last time
 * @property null|iterable|PortConnectionInputInputType[] $listeningPorts = null The list of TCP/IP ports that are in listen mode.
 * @property null|iterable|LogicalDiskInputInputType[] $logicalDisks = null The list of logical disks.
 * @property null|string $logicalSerialNumber = null A logical serial number is used by some vendors in order to inject a logical serial number into the BIOS and overwrite
the device's physical serial number. This approach is used by some devices to work around licenses that are tied to
the device's serial number.
 * @property null|iterable|VirtualDatacenterInputInputType[] $managedVirtualDatacenters = null The virtual datacenters that are managed by this device (e.g. by a VCenter installation running on this device).
 * @property null|string $manufacturer = null The device's manufacturer
 * @property mixed $manufacturingTime = null The manufacturing timestamp
 * @property null|iterable|MemoryModuleSlotInputInputType[] $memoryModuleSlots = null The list of memory module slots with their memory modules (if populated).
 * @property null|iterable|MobileBroadbandDeviceInputInputType[] $mobileBroadbandDevices = null The list of mobile broadband devices (modems).
 * @property null|string $model = null The device's model
 * @property null|iterable|ModuleSlotInputInputType[] $moduleSlots = null The list of module slots with their modules (if populated).
 * @property null|string $name = null The device's name
 * @property null|iterable|NetworkInterfaceInputInputType[] $networkInterfaces = null The list of network interfaces.
 * @property null|NetworkNeighborhoodInputInputType $networkNeighborhood = null The network neighborhood/domain that this device belongs to.
 * @property null|OperatingSystemInputInputType $operatingSystem = null A device's operating system
 * @property null|string $partNumber = null A device's part number
 * @property null|DeviceInputInputType $physicalHost = null Get the physical host for a virtual machine
 * @property null|iterable|ProcessorSlotInputInputType[] $processorSlots = null The list of processor slots with their processors (if populated).
 * @property null|SnmpCommunityInputInputType $readCommunity = null The SNMP read community configured for this device
 * @property null|iterable|DeviceRoleEnum[] $roles = null The set of roles for a device.
 * @property null|iterable|DeviceAttributeInputInputType[] $scalarAttributes = null Gets all scalar attributes for this device (simple attached attributes or custom attributes)
 * @property null|iterable|ScheduledTaskInputInputType[] $scheduledTasks = null The list of all scheduled tasks defined for this computer.
 * @property null|string $serialNumber = null A device's serial number
 * @property null|SnmpAgentDataInputInputType $snmpAgentData = null The basic SNMP agent information for this device.
 * @property null|SnmpV3AccountInputInputType $snmpV3Account = null The SNMPv3 account configured for this device
 * @property null|iterable|SupportEntitlementInputInputType[] $supportEntitlements = null Gets all support entitlements for this device
 * @property null|SystemBoardInputInputType $systemBoard = null The system board for this device.
 * @property null|TpmModuleInputInputType $tpmModule = null The TPM module for this device.
 * @property null|DeviceTypeEnum $type = null A device's type
 * @property null|string $uniqueId = null A device's unqiue id (if it exists)
 * @property null|iterable|VideoControllerSlotInputInputType[] $videoControllerSlots = null The list of video controller slots.
 * @property null|iterable|VirtualDatacenterInputInputType[] $virtualDatacenters = null The virtual datacenters that a device belongs to.
 * @property null|string $discoveryLog = null The discovery log as XML string.
 * @property mixed $discoveryLogObject = null Returns the discovery as parsed object with a hierarchy. This method is used by the UI to display a discovery log in a tree structure
 * @property null|DeviceDiscoveryProtocolStatusInputInputType $discoveryProtocolStatus = null A device's discovery protocol status
 * @property null|iterable|PortConnectionInputInputType[] $tcpIpConnections = null The list of TCP/IP ports and TCP/IP connections where the current device is either the source of the destination of a TCP/IP connection.
 */
final class DeviceInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'accountAssignments') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceAccountAssignmentInputInputType($v)); })($value);
        }

        if ($name === 'arrayAttributes') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceArrayAttributeInputInputType($v)); })($value);
        }

        if ($name === 'attachedAttributes') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceAttributeInputInputType($v)); })($value);
        }

        if ($name === 'bios') {
            return new BiosInputInputType($value);
        }

        if ($name === 'clusters') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new ClusterInputInputType($v)); })($value);
        }

        if ($name === 'computerAccountAssignment') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new ComputerAccountDeviceAssignmentInputInputType($v)); })($value);
        }

        if ($name === 'deviceGroups') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceGroupInputInputType($v)); })($value);
        }

        if ($name === 'diagnosticEvents') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new EventInputInputType($v)); })($value);
        }

        if ($name === 'directory') {
            return new DirectoryInputInputType($value);
        }

        if ($name === 'diskPartitions') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DiskPartitionInputInputType($v)); })($value);
        }

        if ($name === 'diskSlots') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new PhysicalDiskSlotInputInputType($v)); })($value);
        }

        if ($name === 'events') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new EventInputInputType($v)); })($value);
        }

        if ($name === 'iscsiInitiators') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new IscsiPortInputInputType($v)); })($value);
        }

        if ($name === 'iscsiPorts') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new IscsiPortInputInputType($v)); })($value);
        }

        if ($name === 'iscsiTargets') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new IscsiPortInputInputType($v)); })($value);
        }

        if ($name === 'issuedClientAccessLicenses') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new IssuedClientAccessLicenseInputInputType($v)); })($value);
        }

        if ($name === 'javaRisks') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new JavaRiskInputInputType($v)); })($value);
        }

        if ($name === 'listeningPorts') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new PortConnectionInputInputType($v)); })($value);
        }

        if ($name === 'logicalDisks') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new LogicalDiskInputInputType($v)); })($value);
        }

        if ($name === 'managedVirtualDatacenters') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new VirtualDatacenterInputInputType($v)); })($value);
        }

        if ($name === 'memoryModuleSlots') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new MemoryModuleSlotInputInputType($v)); })($value);
        }

        if ($name === 'mobileBroadbandDevices') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new MobileBroadbandDeviceInputInputType($v)); })($value);
        }

        if ($name === 'moduleSlots') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new ModuleSlotInputInputType($v)); })($value);
        }

        if ($name === 'networkInterfaces') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new NetworkInterfaceInputInputType($v)); })($value);
        }

        if ($name === 'networkNeighborhood') {
            return new NetworkNeighborhoodInputInputType($value);
        }

        if ($name === 'operatingSystem') {
            return new OperatingSystemInputInputType($value);
        }

        if ($name === 'physicalHost') {
            return new DeviceInputInputType($value);
        }

        if ($name === 'processorSlots') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new ProcessorSlotInputInputType($v)); })($value);
        }

        if ($name === 'readCommunity') {
            return new SnmpCommunityInputInputType($value);
        }

        if ($name === 'roles') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceRoleEnum($v)); })($value);
        }

        if ($name === 'scalarAttributes') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceAttributeInputInputType($v)); })($value);
        }

        if ($name === 'scheduledTasks') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new ScheduledTaskInputInputType($v)); })($value);
        }

        if ($name === 'snmpAgentData') {
            return new SnmpAgentDataInputInputType($value);
        }

        if ($name === 'snmpV3Account') {
            return new SnmpV3AccountInputInputType($value);
        }

        if ($name === 'supportEntitlements') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new SupportEntitlementInputInputType($v)); })($value);
        }

        if ($name === 'systemBoard') {
            return new SystemBoardInputInputType($value);
        }

        if ($name === 'tpmModule') {
            return new TpmModuleInputInputType($value);
        }

        if ($name === 'type') {
            return new DeviceTypeEnum($value);
        }

        if ($name === 'videoControllerSlots') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new VideoControllerSlotInputInputType($v)); })($value);
        }

        if ($name === 'virtualDatacenters') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new VirtualDatacenterInputInputType($v)); })($value);
        }

        if ($name === 'discoveryProtocolStatus') {
            return new DeviceDiscoveryProtocolStatusInputInputType($value);
        }

        if ($name === 'tcpIpConnections') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new PortConnectionInputInputType($v)); })($value);
        }

        return $value;
    }
}